/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.loc;

import ru.turikhay.tlauncher.ui.TLauncherFrame;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedLabel;

public class LocalizableLabel
extends ExtendedLabel
implements LocalizableComponent {
    private static final long serialVersionUID = 7628068160047735335L;
    protected String path;
    protected String[] variables;
    private boolean notEmpty;

    public LocalizableLabel(String path, Object ... vars) {
        this.setText(path, vars);
        this.setFont(this.getFont().deriveFont(TLauncherFrame.getFontSize()));
    }

    public LocalizableLabel(String path) {
        this(path, Localizable.EMPTY_VARS);
    }

    public LocalizableLabel() {
        this((String)null);
    }

    public LocalizableLabel(int horizontalAlignment) {
        this((String)null);
        this.setHorizontalAlignment(horizontalAlignment);
    }

    public void setText(String path, Object ... vars) {
        this.path = path;
        this.variables = Localizable.checkVariables(vars);
        if (path == null) {
            this.setRawText(this.notEmpty ? " " : "");
            return;
        }
        this.setRawText(Localizable.get(path, vars));
    }

    @Override
    public void setText(String path) {
        this.setText(path, Localizable.EMPTY_VARS);
    }

    @Override
    public void updateLocale() {
        this.setText(this.path, this.variables);
    }

    public void setNotEmpty(boolean flag) {
        this.notEmpty = flag;
        if (this.path == null) {
            this.setText(null);
        }
    }
}

