/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.loc;

import java.awt.Component;
import java.awt.Container;
import ru.turikhay.tlauncher.configuration.LangConfiguration;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.util.U;

public class Localizable {
    public static final Object[] EMPTY_VARS = new Object[0];
    public static final LocalizableFilter defaultFilter = comp -> true;
    private static LangConfiguration lang;

    public static void setLang(LangConfiguration l) {
        lang = l;
    }

    public static LangConfiguration get() {
        return lang;
    }

    public static boolean exists() {
        return lang != null;
    }

    public static String get(String path) {
        return lang != null ? lang.get(path) : path;
    }

    public static String get(String path, Object ... vars) {
        return lang != null ? lang.get(path, vars) : path + " {" + U.toLog(vars) + "}";
    }

    public static String nget(String path) {
        return lang != null ? lang.nget(path) : null;
    }

    public static String[] checkVariables(Object[] check) {
        if (check == null) {
            throw new NullPointerException();
        }
        String[] string = new String[check.length];
        for (int i = 0; i < check.length; ++i) {
            if (check[i] == null) {
                throw new NullPointerException("Variable at index " + i + " is NULL!");
            }
            string[i] = check[i].toString();
        }
        return string;
    }

    public static void updateContainer(Container container, LocalizableFilter filter) {
        for (Component c : container.getComponents()) {
            if (c instanceof LocalizableComponent && filter.localize(c)) {
                ((LocalizableComponent)((Object)c)).updateLocale();
            }
            if (!(c instanceof Container)) continue;
            Localizable.updateContainer((Container)c, filter);
        }
    }

    public static void updateContainer(Container container) {
        Localizable.updateContainer(container, defaultFilter);
    }

    public static interface LocalizableFilter {
        public boolean localize(Component var1);
    }
}

