/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.listener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import net.minecraft.launcher.updater.VersionFilter;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Version;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import net.minecraft.launcher.versions.json.LowerCaseEnumTypeAdapterFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.managers.VersionManagerListener;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.MinecraftUtil;

public class VersionManagerUIListener
implements VersionManagerListener {
    private static final Logger LOGGER = LogManager.getLogger(VersionManagerUIListener.class);
    private final Configuration settings;
    private final Gson gson;
    private boolean firstUpdate = true;
    private File listFile;
    private SimpleVersionList list;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    public VersionManagerUIListener(TLauncher tl) {
        this.settings = tl.getSettings();
        this.gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTypeAdapter(true)).registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory()).setPrettyPrinting().create();
        tl.getVersionManager().addListener(this);
    }

    @Override
    public void onVersionsRefreshing(VersionManager vm) {
    }

    @Override
    public void onVersionsRefreshingFailed(VersionManager vm) {
    }

    @Override
    public void onVersionsRefreshed(VersionManager vm) {
        SimpleVersionList oldList;
        this.listFile = new File(MinecraftUtil.getWorkingDirectory(), "versions/versions.json");
        boolean isFirstUpdate = this.firstUpdate;
        this.firstUpdate = false;
        boolean enabled = false;
        if (this.settings.getBoolean("minecraft.versions.sub.remote")) {
            for (ReleaseType type : ReleaseType.values()) {
                enabled |= this.settings.getBoolean("gui.alerton." + (Object)((Object)type));
            }
        }
        if (!enabled) {
            if (this.listFile.isFile()) {
                try {
                    FileUtil.deleteFile(this.listFile);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not delete version index file: {}", (Object)this.listFile, (Object)e);
                }
            }
            return;
        }
        SimpleVersionList simpleVersionList = oldList = this.list == null ? this.fetchListFromFile() : this.list;
        if (oldList == null) {
            LOGGER.debug("Old list is empty, saving current one for the next time.");
            this.list = this.fetchListFromManager(vm);
            this.saveList(this.list);
            return;
        }
        SimpleVersionList newList = this.fetchListFromManager(vm);
        TreeMap newVersions = new TreeMap();
        SimpleVersion lastVersion = null;
        int i = 0;
        for (SimpleVersion version : newList.versions) {
            List<SimpleVersion> subVersionList;
            if (oldList.versions.contains(version)) continue;
            ++i;
            lastVersion = version;
            if (!this.settings.getBoolean("gui.alerton." + (Object)((Object)version.type))) continue;
            switch (version.type) {
                case RELEASE: 
                case SNAPSHOT: {
                    break;
                }
                default: {
                    version.type = ReleaseType.UNKNOWN;
                }
            }
            if (newVersions.containsKey((Object)version.type)) {
                subVersionList = (List)newVersions.get((Object)version.type);
            } else {
                subVersionList = new ArrayList();
                newVersions.put(version.type, subVersionList);
            }
            subVersionList.add(version);
        }
        if (newVersions.isEmpty()) {
            return;
        }
        StringBuilder text = new StringBuilder(Localizable.get("version.manager.alert.header.found" + (isFirstUpdate ? ".welcome" : ""))).append(" ");
        if (i == 1) {
            text.append(Localizable.get("version.manager.alert.header.single." + (Object)((Object)lastVersion.type))).append("\n");
            this.add(text, lastVersion);
        } else {
            text.append(Localizable.get("version.manager.alert.header.multiple")).append("\n");
            List unknownNew = (List)newVersions.get((Object)ReleaseType.UNKNOWN);
            if (newVersions.size() == 1 && unknownNew != null) {
                for (SimpleVersion version : (List)newVersions.get((Object)ReleaseType.UNKNOWN)) {
                    this.add(text, version);
                }
            } else {
                block8: for (Map.Entry entry : newVersions.entrySet()) {
                    ReleaseType type = (ReleaseType)((Object)entry.getKey());
                    List versionList = (List)entry.getValue();
                    if (versionList.isEmpty()) continue;
                    text.append('\n').append(Localizable.get("version.manager.alert." + (Object)((Object)type) + "." + (versionList.size() == 1 ? "single" : "multiple"))).append('\n');
                    int k = 0;
                    for (SimpleVersion version : versionList) {
                        LOGGER.debug("New version: {}", (Object)version);
                        if (++k == 5) {
                            LOGGER.debug("... and probably more new versions");
                            text.append(Localizable.get("version.manager.alert.more", versionList.size() - k + 1)).append('\n');
                            continue block8;
                        }
                        this.add(text, version);
                    }
                }
            }
        }
        Alert.showMessage(Localizable.get("version.manager.alert.title"), text.toString());
        this.list = newList;
        this.saveList(newList);
    }

    private void saveList(SimpleVersionList versionList) {
        File dir = this.listFile.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new RuntimeException("Unable to create parent directory for version list");
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(this.listFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            this.gson.toJson((Object)versionList, (Appendable)writer);
        }
        catch (Exception e) {
            LOGGER.error("Could not write version list file: {}", (Object)this.listFile, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private SimpleVersionList fetchListFromFile() {
        SimpleVersionList simpleVersionList;
        InputStreamReader reader = new InputStreamReader(Files.newInputStream(this.listFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
        try {
            simpleVersionList = (SimpleVersionList)this.gson.fromJson((Reader)reader, SimpleVersionList.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Could not read version list from file: {}", (Object)this.listFile, (Object)e);
                return null;
            }
        }
        ((Reader)reader).close();
        return simpleVersionList;
    }

    private SimpleVersionList fetchListFromManager(VersionManager vm) {
        try {
            SimpleVersionList versionList = new SimpleVersionList();
            for (VersionSyncInfo syncInfo : vm.getVersions(new VersionFilter(), false)) {
                versionList.versions.add(new SimpleVersion(syncInfo));
            }
            return versionList;
        }
        catch (Exception e) {
            LOGGER.error("Could not fetch list from manager", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void add(StringBuilder b, SimpleVersion version) {
        b.append("\u2013 ").append(version.id).append(" (").append(this.getTimeDifference(version.time)).append(")").append('\n');
    }

    private static Calendar cal() {
        return Calendar.getInstance(UTC);
    }

    private static Calendar cal(Date date) {
        Calendar calendar = VersionManagerUIListener.cal();
        calendar.setTime(date);
        return calendar;
    }

    private static Calendar cal(long time) {
        Calendar calendar = VersionManagerUIListener.cal();
        calendar.setTimeInMillis(time);
        return calendar;
    }

    private String getTimeDifference(Date time) {
        if (time == null) {
            return Localizable.get("version.manager.alert.time.unknown");
        }
        Calendar currentTime = VersionManagerUIListener.cal();
        Calendar releaseTime = VersionManagerUIListener.cal(time);
        Calendar difference = VersionManagerUIListener.cal(currentTime.getTimeInMillis() - releaseTime.getTimeInMillis());
        String path = "version.manager.alert.time.";
        int field = -1;
        if (difference.get(1) > 1970) {
            path = path + "longtimeago";
        } else if (difference.get(3) > 2) {
            path = path + "week";
            field = difference.get(3) - 1;
        } else if (difference.get(6) > 1) {
            path = path + "day";
            field = difference.get(6);
        } else if (difference.get(11) > 1) {
            path = path + "hour";
            field = difference.get(11);
        } else if (difference.get(12) > 1) {
            path = path + "minute";
            field = difference.get(12);
        } else {
            path = path + "justnow";
        }
        return field == -1 ? Localizable.get(path) : Localizable.get(path, field);
    }

    private static class SimpleVersionList {
        String _notice = "Pretend that you are not reading this. And this file does not exist. It does not affect anything important. Just for indexing. Hvae fnu!";
        final List<SimpleVersion> versions = new ArrayList<SimpleVersion>();

        private SimpleVersionList() {
        }

        boolean contains(SimpleVersion version) {
            return this.versions.contains(version);
        }

        public String toString() {
            return "SimpleVersionList[" + this.versions + "]";
        }
    }

    private static class SimpleVersion {
        private final String id;
        private ReleaseType type;
        private final Date releaseTime;
        private final Date time;

        SimpleVersion(VersionSyncInfo syncInfo) {
            this.id = syncInfo.getID();
            Version version = syncInfo.getAvailableVersion();
            this.type = version.getReleaseType();
            this.releaseTime = version.getReleaseTime();
            this.time = version.getUpdatedTime();
            boolean hasRemote = syncInfo.hasRemote();
        }

        SimpleVersion(String id, ReleaseType type, Date date) {
            this.id = id;
            this.type = type;
            this.releaseTime = this.time = date;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SimpleVersion)) {
                return false;
            }
            SimpleVersion v = (SimpleVersion)o;
            return this.id.equals(v.id);
        }

        public String toString() {
            return "SimpleVersion{id=" + this.id + ",type=" + (Object)((Object)this.type) + ",releaseTime=" + this.releaseTime + ",time=" + this.time + "}";
        }
    }
}

