/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftExtendedListener;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftListener;
import ru.turikhay.tlauncher.minecraft.launcher.SwingMinecraftExtendedListener;
import ru.turikhay.tlauncher.minecraft.launcher.SwingMinecraftListener;
import ru.turikhay.tlauncher.ui.listener.MinecraftUIListener;
import ru.turikhay.tlauncher.ui.listener.VersionManagerUIListener;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;

public final class UIListeners
implements LocalizableComponent {
    private final MinecraftUIListener minecraftUIListener;
    private final List<MinecraftListener> minecraftListeners = new ArrayList<MinecraftListener>();
    private final VersionManagerUIListener versionManagerUIListener;

    public UIListeners(TLauncher tlauncher) {
        this.minecraftUIListener = new MinecraftUIListener(tlauncher);
        this.minecraftListeners.add(this.minecraftUIListener);
        this.versionManagerUIListener = new VersionManagerUIListener(tlauncher);
    }

    public MinecraftUIListener getMinecraftUIListener() {
        return this.minecraftUIListener;
    }

    public List<MinecraftListener> getMinecraftListeners() {
        return Collections.unmodifiableList(this.minecraftListeners);
    }

    public void registerMinecraftLauncherListener(MinecraftListener listener) {
        this.minecraftListeners.add(new SwingMinecraftListener(listener));
    }

    public void registerMinecraftLauncherListener(MinecraftExtendedListener listener) {
        this.minecraftListeners.add(new SwingMinecraftExtendedListener(listener));
    }

    public VersionManagerUIListener getVersionManagerUIListener() {
        return this.versionManagerUIListener;
    }

    @Override
    public void updateLocale() {
        for (MinecraftListener l : this.minecraftListeners) {
            if (!(l instanceof LocalizableComponent)) continue;
            ((LocalizableComponent)((Object)l)).updateLocale();
        }
    }
}

