/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.listener;

import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.configuration.LangConfiguration;
import ru.turikhay.tlauncher.minecraft.crash.Crash;
import ru.turikhay.tlauncher.minecraft.crash.CrashManager;
import ru.turikhay.tlauncher.minecraft.crash.CrashManagerListener;
import ru.turikhay.tlauncher.minecraft.crash.SwingCrashManagerListener;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftException;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftListener;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.crash.CrashProcessingFrame;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.swing.DelayedComponent;
import ru.turikhay.tlauncher.ui.swing.DelayedComponentLoader;
import ru.turikhay.util.SwingUtil;

public class MinecraftUIListener
implements MinecraftListener,
CrashManagerListener,
LocalizableComponent {
    private final DelayedComponent<CrashProcessingFrame> crashFrame;
    private final TLauncher t;
    private final LangConfiguration lang;

    public MinecraftUIListener(TLauncher tlauncher) {
        this.t = tlauncher;
        this.lang = this.t.getLang();
        this.crashFrame = new DelayedComponent<CrashProcessingFrame>(new DelayedComponentLoader<CrashProcessingFrame>(){

            @Override
            public CrashProcessingFrame loadComponent() {
                return new CrashProcessingFrame();
            }

            @Override
            public void onComponentLoaded(CrashProcessingFrame loaded) {
                TLauncher.getInstance().getFrame().updateLocales();
            }
        });
    }

    public DelayedComponent<CrashProcessingFrame> getCrashProcessingFrame() {
        return this.crashFrame;
    }

    @Override
    public void onMinecraftPrepare() {
    }

    @Override
    public void onMinecraftAbort() {
    }

    @Override
    public void onMinecraftLaunch() {
        if (!this.t.getSettings().getActionOnLaunch().equals((Object)Configuration.ActionOnLaunch.NOTHING)) {
            SwingUtil.later(() -> this.t.getFrame().setVisible(false));
        }
    }

    @Override
    public void onMinecraftClose() {
        if (this.t.getMinecraftLauncher().isLaunchAssist()) {
            SwingUtil.later(() -> {
                this.t.getFrame().setVisible(true);
                this.t.getFrame().getNotices().selectRandom();
            });
        }
    }

    @Override
    public void onMinecraftError(Throwable e) {
        Alert.showLocError("launcher.error.title", "launcher.error.unknown", e);
    }

    @Override
    public void onMinecraftKnownError(MinecraftException e) {
        Alert.showError(this.lang.get("launcher.error.title"), this.lang.get("launcher.error." + e.getLangPath(), e.getLangVars()), e.getCause());
    }

    @Override
    public void onCrashManagerInit(CrashManager manager) {
        manager.addListener(new SwingCrashManagerListener(this));
        manager.addListener(new SwingCrashManagerListener(this.crashFrame.get()));
    }

    @Override
    public void onCrashManagerProcessing(CrashManager manager) {
    }

    @Override
    public void onCrashManagerComplete(CrashManager manager, Crash crash) {
    }

    @Override
    public void onCrashManagerCancelled(CrashManager manager) {
    }

    @Override
    public void onCrashManagerFailed(CrashManager manager, Exception e) {
        Alert.showLocError("crash.error", TLauncher.getSupportEmail());
    }

    @Override
    public void updateLocale() {
        SwingUtil.later(() -> {
            if (this.crashFrame.isLoaded()) {
                this.crashFrame.get().updateLocale();
            }
        });
    }
}

