/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.listener;

import java.io.IOException;
import java.util.Locale;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.minecraft.auth.Authenticator;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorListener;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.login.LoginException;
import ru.turikhay.tlauncher.user.AuthDetailedException;
import ru.turikhay.tlauncher.user.AuthException;
import ru.turikhay.tlauncher.user.AuthUnknownException;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.util.SwingException;
import ru.turikhay.util.SwingUtil;

public class AuthUIListener<U extends User>
implements AuthenticatorListener<U> {
    private final AuthenticatorListener<U> listener;
    public boolean editorOpened = false;

    public AuthUIListener(AuthenticatorListener<U> listener) {
        this.listener = listener;
    }

    @Override
    public void onAuthPassing(Authenticator<? extends U> auth) {
        if (this.listener != null) {
            SwingUtil.wait(() -> this.listener.onAuthPassing(auth));
        }
    }

    @Override
    public void onAuthPassingError(Authenticator<? extends U> auth, Throwable e) {
        this.showError(auth, e);
        if (this.listener != null) {
            try {
                SwingUtil.wait(() -> this.listener.onAuthPassingError(auth, e));
            }
            catch (SwingException swingException) {
                Throwable t = swingException.unpackException();
                if (t instanceof LoginException) {
                    throw (LoginException)t;
                }
                throw swingException;
            }
        }
    }

    private void showError(Authenticator<? extends U> auth, Throwable e) {
        String title = "account.manager.error.title";
        String locPath = "unknown";
        Object[] locVars = null;
        Object textarea = null;
        if (e instanceof IOException) {
            locPath = "ioe";
            textarea = e;
        }
        if (e instanceof AuthException) {
            locPath = ((AuthException)e).getLocPath();
            locVars = ((AuthException)e).getLocVars();
            if (e instanceof AuthUnknownException) {
                textarea = e;
            } else if (e instanceof AuthDetailedException) {
                textarea = ((AuthDetailedException)e).getErrorContent();
            } else if (e.getCause() != null) {
                textarea = e.getCause().toString();
            }
        }
        Account.AccountType accountType = auth.getType();
        String path = "account.manager.error." + accountType.toString().toLowerCase(Locale.ROOT) + "." + locPath + (this.editorOpened ? ".editor" : "");
        if (this.editorOpened && Localizable.nget(path) == null) {
            path = "account.manager.error." + accountType.toString().toLowerCase(Locale.ROOT) + "." + locPath;
        }
        if (Localizable.nget(path) == null) {
            path = "account.manager.error." + locPath + (this.editorOpened ? ".editor" : "");
        }
        if (this.editorOpened && Localizable.nget(path) == null) {
            path = "account.manager.error." + locPath;
        }
        String description = Localizable.get(path, locVars);
        Alert.showLocError(title, description, textarea);
    }

    @Override
    public void onAuthPassed(Authenticator<? extends U> auth) {
        if (this.listener != null) {
            SwingUtil.wait(() -> this.listener.onAuthPassed(auth));
        }
        this.saveProfiles();
    }

    public void saveProfiles() {
        try {
            TLauncher.getInstance().getProfileManager().saveProfiles();
        }
        catch (IOException var2) {
            Alert.showLocError("auth.profiles.save-error");
        }
    }
}

