/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.images;

import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.ui.images.ClassResourceLocator;
import ru.turikhay.tlauncher.ui.images.CompatibleIconProcessor;
import ru.turikhay.tlauncher.ui.images.DarkThemeAwareResourceLocator;
import ru.turikhay.tlauncher.ui.images.DuplicateAwareResourceLocator;
import ru.turikhay.tlauncher.ui.images.IconProcessor;
import ru.turikhay.tlauncher.ui.images.ImageIcon;
import ru.turikhay.tlauncher.ui.images.ImageResourceLocator;
import ru.turikhay.tlauncher.ui.images.PrefixResourceLocator;
import ru.turikhay.tlauncher.ui.images.ResourceLoadException;
import ru.turikhay.tlauncher.ui.images.ResourceNotFoundException;
import ru.turikhay.tlauncher.ui.images.ThemeColorIconProcessor;
import ru.turikhay.util.Lazy;

public class Images {
    private static final Logger LOGGER = LogManager.getLogger(Images.class);
    private static final Pattern ICON_FILENAME_PATTERN = Pattern.compile("([A-Za-z-._]+)@([\\d]+)\\.png");
    private static final ImageResourceLocator RESOURCE_LOCATOR = new DuplicateAwareResourceLocator(new DarkThemeAwareResourceLocator((ImageResourceLocator)new PrefixResourceLocator(new ClassResourceLocator(Images.class), Arrays.asList("fa/", "")), "dark/"));
    private static final IconProcessor ICON_PROCESSOR = new ThemeColorIconProcessor(CompatibleIconProcessor.create());
    public static final Lazy<BufferedImage> ONE_PIX;

    public static ImageIcon getIcon(String name, int size) {
        return new ImageIcon(Images.loadIcon(name, size), size);
    }

    public static Image loadIcon(String name, int size) {
        BufferedImage baseImage;
        URL url;
        String resourceName = Images.toIconResourceName(name);
        try {
            url = Images.findLocation(resourceName);
        }
        catch (ResourceNotFoundException e) {
            return Images.reportMissingAndReturnEmptyImage(e);
        }
        try {
            baseImage = Images.loadImageByUrl(url);
        }
        catch (ResourceLoadException e) {
            return Images.reportLoadErrorAndReturnEmptyImage(e);
        }
        return ICON_PROCESSOR.processBaseIcon(baseImage, name, size);
    }

    public static BufferedImage loadImageByName(String resourceName) {
        URL url;
        try {
            url = Images.findLocation(resourceName);
        }
        catch (ResourceNotFoundException e) {
            return Images.reportMissingAndReturnEmptyImage(e);
        }
        try {
            return Images.loadImageByUrl(url);
        }
        catch (ResourceLoadException e) {
            return Images.reportLoadErrorAndReturnEmptyImage(e);
        }
    }

    public static Image loadIconById(String id) {
        Matcher isIcon = ICON_FILENAME_PATTERN.matcher(Objects.requireNonNull(id, "id"));
        if (!isIcon.matches()) {
            throw new IllegalArgumentException("bad icon id: " + id);
        }
        String name = isIcon.group(1);
        int size = Integer.parseInt(isIcon.group(2));
        return Images.loadIcon(name, size);
    }

    private static URL findLocation(String resourceName) throws ResourceNotFoundException {
        Optional<URL> url = RESOURCE_LOCATOR.loadResource(resourceName);
        if (!url.isPresent()) {
            throw new ResourceNotFoundException(resourceName);
        }
        return url.get();
    }

    private static BufferedImage loadImageByUrl(URL url) throws ResourceLoadException {
        BufferedImage image;
        Objects.requireNonNull(url, "url");
        try {
            image = ImageIO.read(url);
        }
        catch (IOException e) {
            throw new ResourceLoadException(url, (Throwable)e);
        }
        if (image == null) {
            throw new ResourceLoadException(url, (Throwable)new NullPointerException("ImageIO.read"));
        }
        return image;
    }

    private static BufferedImage reportMissingAndReturnEmptyImage(ResourceNotFoundException e) {
        LOGGER.error("Missing resource", (Throwable)e);
        Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.ERROR).withMessage("missing resource: " + e.getMessage()).withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)));
        return ONE_PIX.get();
    }

    private static BufferedImage reportLoadErrorAndReturnEmptyImage(ResourceLoadException e) {
        LOGGER.error("Resource cannot be loaded", (Throwable)e);
        Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.ERROR).withMessage("resource loading error").withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)).withExtra("resourceUrl", (Object)String.valueOf(e.getUrl())));
        return ONE_PIX.get();
    }

    private static String toIconResourceName(String name) {
        return String.format(Locale.ROOT, "%s.png", name);
    }

    public static ImageIcon getIcon16(String name) {
        return Images.getIcon(name, 16);
    }

    public static Lazy<ImageIcon> getIcon16Lazy(String name) {
        return Lazy.of(() -> Images.getIcon16(name));
    }

    public static ImageIcon getIcon24(String name) {
        return Images.getIcon(name, 24);
    }

    public static ImageIcon getIcon32(String name) {
        return Images.getIcon(name, 32);
    }

    public static ImageIcon getIcon48(String name) {
        return Images.getIcon(name, 48);
    }

    public static ImageIcon getIcon64(String name) {
        return Images.getIcon(name, 64);
    }

    public static Image loadIcon16(String name) {
        return Images.loadIcon(name, 16);
    }

    public static Image loadIcon24(String name) {
        return Images.loadIcon(name, 24);
    }

    public static Image loadIcon32(String name) {
        return Images.loadIcon(name, 32);
    }

    public static Image loadIcon48(String name) {
        return Images.loadIcon(name, 48);
    }

    public static Image loadIcon64(String name) {
        return Images.loadIcon(name, 64);
    }

    static {
        ImageIO.setUseCache(false);
        ONE_PIX = Lazy.of(() -> new BufferedImage(1, 1, 6));
    }
}

