/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.images;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ru.turikhay.tlauncher.ui.images.DisabledImageIcon;
import ru.turikhay.tlauncher.ui.images.ExtendedIcon;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedLabel;
import ru.turikhay.util.Lazy;

public class ImageIcon
extends ExtendedLabel
implements ExtendedIcon {
    private Image image;
    private final int size;
    private final Lazy<DisabledImageIcon> disabledInstance = Lazy.of(() -> new DisabledImageIcon(this));

    protected ImageIcon(Image image, int size) {
        this.image = image;
        this.size = size;
    }

    protected void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    @Override
    public DisabledImageIcon getDisabledInstance() {
        return this.disabledInstance.get();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.image != null) {
            g.drawImage(this.image, x, y, null);
        }
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }

    public void setup(JComponent comp) {
        ImageIcon.setup(comp, this);
    }

    public static ImageIcon setup(JComponent component, ImageIcon icon) {
        if (component == null) {
            return null;
        }
        if (component instanceof JLabel) {
            ((JLabel)component).setIcon(icon);
            ((JLabel)component).setDisabledIcon(icon == null ? null : icon.getDisabledInstance());
        } else if (component instanceof AbstractButton) {
            ((AbstractButton)component).setIcon(icon);
            ((AbstractButton)component).setDisabledIcon(icon == null ? null : icon.getDisabledInstance());
        } else {
            throw new IllegalArgumentException();
        }
        return icon;
    }
}

