/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.images;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import ru.turikhay.tlauncher.handlers.ExceptionHandler;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.async.AsyncThread;

public class FixedSizeImage
extends JComponent {
    private final SoftReference<Image> ogImageRef;
    private final AtomicInteger tick = new AtomicInteger();
    private volatile SoftReference<BufferedImage> imageRef;

    public FixedSizeImage(Image image) {
        this.ogImageRef = new SoftReference<Image>(image);
        this.imageRef = new SoftReference<Object>(null);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                FixedSizeImage.this.invalidateImage();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                FixedSizeImage.this.invalidateImage();
            }
        });
    }

    private void invalidateImage() {
        int expectedTick = this.tick.incrementAndGet();
        AsyncThread.execute(() -> this.invalidateImage(expectedTick));
    }

    private void invalidateImage(int expectedTick) {
        BufferedImage newImage;
        Image ogImage = this.ogImageRef.get();
        if (ogImage == null) {
            this.imageRef.clear();
            return;
        }
        Dimension size = SwingUtil.waitAndReturn(this::getSize);
        if (this.tick.get() != expectedTick) {
            return;
        }
        Image image = this.imageRef.get();
        if (image != null && image.getWidth(null) == size.width && image.getHeight(null) == size.height) {
            return;
        }
        double scalingFactor = SwingUtil.getScalingFactor();
        try {
            newImage = new BufferedImage((int)(scalingFactor * (double)size.width), (int)(scalingFactor * (double)size.height), 5);
            Graphics2D g = (Graphics2D)newImage.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.drawImage(ogImage, 0, 0, newImage.getWidth(), newImage.getHeight(), null);
        }
        catch (OutOfMemoryError oom) {
            ExceptionHandler.reduceMemory(oom);
            newImage = Images.ONE_PIX.get();
        }
        if (this.tick.get() != expectedTick) {
            return;
        }
        this.imageRef = new SoftReference<BufferedImage>(newImage);
        SwingUtil.later(this::repaint);
    }

    @Override
    public void paint(Graphics g0) {
        Image image = this.imageRef.get();
        if (image == null) {
            return;
        }
        Graphics2D g = (Graphics2D)g0;
        g.drawImage(image, 0, 0, this.getWidth(), this.getHeight(), this);
    }
}

