/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.images;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.ui.images.DisabledImageIcon;
import ru.turikhay.tlauncher.ui.images.ExtendedIcon;
import ru.turikhay.tlauncher.ui.images.MultiResInterface;
import ru.turikhay.tlauncher.ui.notice.NoticeImage;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedLabel;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.async.AsyncThread;

public class DelayedIcon
extends ExtendedLabel
implements ExtendedIcon {
    private static final Logger LOGGER = LogManager.getLogger(DelayedIcon.class);
    private Image icon;
    private Dimension size;
    private volatile IconLoader loader;
    private final DisabledImageIcon disabledInstance = new DisabledImageIcon(this);

    public DelayedIcon(NoticeImage image, int targetWidth, int targetHeight) {
        this();
        this.setImage(image, targetWidth, targetHeight, false);
    }

    public DelayedIcon() {
        this.setIcon(this);
        this.setDisabledIcon(this.getDisabledInstance());
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.icon != null) {
            g.drawImage(this.icon, x, y, null);
        }
    }

    public void setImage(Future<Image> icon, int iconWidth, int iconHeight, int targetWidth, int targetHeight, boolean repaint) {
        this.icon = null;
        this.size = DelayedIcon.computeSize(iconWidth, iconHeight, targetWidth, targetHeight);
        this.loader = new IconLoader(icon, this.size);
        AsyncThread.future(this.loader);
        if (repaint) {
            this.repaint();
        }
    }

    public void setImage(NoticeImage image, int targetWidth, int targetHeight, boolean repaint) {
        this.setImage(image.getTask(), image.getWidth(), image.getHeight(), targetWidth, targetHeight, repaint);
    }

    public void setImage(NoticeImage image, int targetWidth, int targetHeight) {
        this.setImage(image.getTask(), image.getWidth(), image.getHeight(), targetWidth, targetHeight, true);
    }

    private void iconLoaded(Image icon) {
        this.icon = icon;
        this.repaint();
    }

    @Override
    public int getIconWidth() {
        return this.size == null ? 0 : this.size.width;
    }

    @Override
    public int getIconHeight() {
        return this.size == null ? 0 : this.size.height;
    }

    @Override
    public DisabledImageIcon getDisabledInstance() {
        return this.disabledInstance;
    }

    private static Dimension computeSize(int iconWidth, int iconHeight, int targetWidth, int targetHeight) {
        int height;
        int width;
        if (targetWidth == 0 && targetHeight == 0) {
            return new Dimension(iconWidth, iconHeight);
        }
        double ratio = (double)iconWidth / (double)iconHeight;
        if (targetHeight == 0) {
            width = targetWidth;
            height = (int)((double)targetWidth / ratio);
        } else if (targetWidth == 0) {
            width = (int)((double)targetHeight * ratio);
            height = targetHeight;
        } else {
            width = targetWidth;
            height = targetHeight;
        }
        return new Dimension(width, height);
    }

    private static Image scaledIcon(Image icon, int width, int height, double scale) {
        int hints = 4;
        if (scale == 1.0) {
            return icon.getScaledInstance(width, height, 4);
        }
        return icon.getScaledInstance((int)(scale * (double)width), (int)(scale * (double)height), 4);
    }

    private static Image toMultiResIcon(Image icon, int width, int height) {
        return MultiResInterface.INSTANCE.createImage(DelayedIcon.scaledIcon(icon, width, height, 1.0), DelayedIcon.scaledIcon(icon, width, height, SwingUtil.getScalingFactor()));
    }

    private class IconLoader
    implements Runnable {
        private final Future<Image> task;
        private final Dimension size;

        IconLoader(Future<Image> task, Dimension size) {
            this.task = Objects.requireNonNull(task);
            this.size = size;
        }

        @Override
        public void run() {
            Image icon;
            try {
                icon = this.task.get();
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn("Interrupted while waiting for icon");
                return;
            }
            catch (ExecutionException e) {
                LOGGER.warn("Icon loading failed", (Throwable)e);
                return;
            }
            Image result = MultiResInterface.INSTANCE.isEnabled() ? DelayedIcon.toMultiResIcon(icon, this.size.width, this.size.height) : DelayedIcon.scaledIcon(icon, this.size.width, this.size.height, 1.0);
            if (DelayedIcon.this.loader == this) {
                SwingUtil.later(() -> DelayedIcon.this.iconLoaded(result));
            } else {
                LOGGER.debug("Icon loader result discarded");
            }
        }
    }
}

