/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.images;

import java.awt.Image;
import java.awt.image.BufferedImage;
import ru.turikhay.tlauncher.ui.images.IconProcessor;
import ru.turikhay.tlauncher.ui.images.MultiResInterface;
import ru.turikhay.tlauncher.ui.images.PlainIconProcessor;
import ru.turikhay.util.SwingUtil;

class CompatibleIconProcessor
implements IconProcessor {
    private final IconProcessor delegateProcessor;

    CompatibleIconProcessor(IconProcessor delegateProcessor) {
        this.delegateProcessor = delegateProcessor;
    }

    @Override
    public Image processBaseIcon(BufferedImage baseIcon, String iconName, int targetSize) {
        return this.delegateProcessor.processBaseIcon(baseIcon, iconName, targetSize);
    }

    static CompatibleIconProcessor create() {
        return CompatibleIconProcessor.create(SwingUtil.getScalingFactor());
    }

    private static CompatibleIconProcessor create(double scalingFactor) {
        IconProcessor processor = CompatibleIconProcessor.isMultiResAvailable() && scalingFactor != 1.0 ? MultiResInterface.INSTANCE.createIconProcessor(scalingFactor) : new PlainIconProcessor();
        return new CompatibleIconProcessor(processor);
    }

    static boolean isMultiResAvailable() {
        return MultiResInterface.INSTANCE.isEnabled();
    }
}

