/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.frames;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.Box;
import ru.turikhay.tlauncher.ui.frames.ActionFrame;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.swing.MagnifiedInsets;
import ru.turikhay.tlauncher.ui.swing.editor.EditorPane;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.ui.swing.extended.VPanel;
import ru.turikhay.util.SwingUtil;

public class VActionFrame
extends ActionFrame {
    private final LocalizableLabel head;
    private final BorderPanel holder;
    private final VPanel body;
    private final VActionBody bodyText;
    protected final int labelWidth;
    private final ExtendedPanel footer;

    public VActionFrame(int width) {
        this.labelWidth = width;
        this.setMaximumSize(new Dimension(width, Integer.MAX_VALUE));
        this.setIconImages(SwingUtil.getFavicons());
        this.holder = new BorderPanel();
        this.holder.setVgap(5);
        this.holder.setInsets(new MagnifiedInsets(10, 20, 20, 20));
        this.add(this.holder);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                VActionFrame.this.holder.setPreferredSize(VActionFrame.this.getRootPane().getSize());
                VActionFrame.this.bodyText.setMinimumSize(new Dimension(Integer.MAX_VALUE, 1));
            }
        });
        this.head = new LocalizableLabel();
        this.head.setFont(this.head.getFont().deriveFont(this.head.getFont().getSize2D() + 18.0f).deriveFont(1));
        this.head.setIconTextGap(SwingUtil.magnify(10));
        this.holder.setNorth(this.head);
        this.body = new VPanel();
        this.body.add(Box.createRigidArea(SwingUtil.magnify(new Dimension(1, 4))));
        this.holder.setCenter(this.body);
        this.bodyText = new VActionBody();
        this.body.add((Component)this.bodyText);
        this.footer = new ExtendedPanel();
        this.holder.setSouth(this.footer);
    }

    public VActionFrame() {
        this(500);
    }

    public final BorderPanel getHolder() {
        return this.holder;
    }

    @Override
    public final LocalizableLabel getHead() {
        return this.head;
    }

    @Override
    public final VPanel getBody() {
        return this.body;
    }

    public final VActionBody getBodyText() {
        return this.bodyText;
    }

    @Override
    public final ExtendedPanel getFooter() {
        return this.footer;
    }

    public int getLabelWidth() {
        return this.labelWidth;
    }

    @Override
    public void pack() {
        super.pack();
        this.bodyText.calcText();
    }

    public class VActionBody
    extends EditorPane {
        protected VActionBody() {
            this.setAlignmentX(0.0f);
        }

        @Override
        public void setText(String text) {
            super.setText(Localizable.get(text));
            this.calcText();
        }

        public void setText(String text, Object ... vars) {
            super.setText(Localizable.get(text, vars));
            this.calcText();
        }

        public void calcText() {
            this.setPreferredSize(new Dimension(VActionFrame.this.labelWidth, SwingUtil.getPrefHeight(this, VActionFrame.this.labelWidth)));
        }
    }
}

