/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.frames;

import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ru.turikhay.tlauncher.ui.frames.BActionFrame;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.progress.ProgressBar;
import ru.turikhay.util.SwingUtil;

public class ProcessFrame<T>
extends BActionFrame {
    private final ExecutorService service = Executors.newCachedThreadPool();
    private volatile Process process;
    private volatile Process succeededProcess;

    public ProcessFrame() {
        this.setMinimumSize(SwingUtil.magnify(new Dimension(500, 1)));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (ProcessFrame.this.process != ProcessFrame.this.succeededProcess) {
                    ProcessFrame.this.onCancelled();
                }
                ProcessFrame.this.process = null;
                ProcessFrame.this.succeededProcess = null;
            }
        });
        ProgressBar progress = new ProgressBar();
        progress.setPreferredSize(new Dimension(1, SwingUtil.magnify(32)));
        progress.setIndeterminate(true);
        this.getBody().setCenter(progress);
    }

    public final void setIcon(String path) {
        this.getBody().setWest(Images.getIcon32(path));
    }

    public final void submit(Process process) {
        this.process = process;
        if (process != null) {
            this.service.submit(process);
        } else {
            this.onCancelled();
        }
    }

    protected void onProcessing(Process process) {
        this.checkIfCurrent(process);
        this.showAtCenter();
    }

    protected void onSucceeded(Process process, T result) {
        this.checkIfCurrent(process);
        this.succeededProcess = process;
        this.setVisible(false);
    }

    protected void onFailed(Process process, Exception e) {
        this.checkIfCurrent(process);
        this.setVisible(false);
    }

    protected void onCancelled() {
        this.setVisible(false);
    }

    protected void checkIfCurrent(Process process) throws IllegalStateException {
        if (this.process != process) {
            throw new IllegalStateException();
        }
    }

    public abstract class Process
    implements Runnable {
        @Override
        public void run() {
            Object result;
            SwingUtil.wait(() -> ProcessFrame.this.onProcessing(this));
            try {
                result = this.get();
            }
            catch (Exception e) {
                SwingUtil.wait(() -> ProcessFrame.this.onFailed(this, e));
                return;
            }
            SwingUtil.wait(() -> ProcessFrame.this.onSucceeded(this, result));
        }

        protected abstract T get() throws Exception;
    }
}

