/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.frames;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.editor.EditorFileField;
import ru.turikhay.tlauncher.ui.explorer.FileExplorer;
import ru.turikhay.tlauncher.ui.frames.VActionFrame;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;

public class NewFolderFrame
extends VActionFrame {
    private static final Logger LOGGER = LogManager.getLogger(NewFolderFrame.class);
    private final TLauncher t;

    public NewFolderFrame(TLauncher t, File file) {
        super(SwingUtil.magnify(500));
        FileExplorer dirExplorer;
        this.t = t;
        this.setDefaultCloseOperation(2);
        this.setTitlePath("newfolder.title", new Object[0]);
        this.getHead().setText("newfolder.head");
        this.getBodyText().setText("newfolder.body");
        try {
            dirExplorer = FileExplorer.newExplorer();
            dirExplorer.setFileSelectionMode(1);
            dirExplorer.setFileHidingEnabled(false);
        }
        catch (Exception e2) {
            dirExplorer = null;
        }
        EditorFileField fileField = new EditorFileField("newfolder.select.prompt", "newfolder.select.browse", dirExplorer, false, false);
        fileField.setSettingsValue(file.getAbsolutePath());
        ExtendedPanel fileFieldShell = new ExtendedPanel();
        fileFieldShell.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        fileFieldShell.add((Component)new LocalizableLabel("newfolder.select.title"), c);
        ++c.gridy;
        fileFieldShell.add((Component)fileField, c);
        this.getBody().add((Component)fileFieldShell);
        this.getFooter().setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = -1;
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 3;
        LocalizableButton cancelButton = new LocalizableButton("newfolder.button.cancel");
        cancelButton.addActionListener(e -> this.dispose());
        this.getFooter().add((Component)cancelButton, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.getFooter().add((Component)new ExtendedPanel(), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 3;
        final LocalizableButton okButton = new LocalizableButton("newfolder.button.ok");
        okButton.setPreferredSize(SwingUtil.magnify(new Dimension(150, 40)));
        okButton.addActionListener(e -> this.changeFolder(fileField.isValueValid() ? fileField.getSelectedFile() : null));
        this.getFooter().add((Component)okButton, c);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                okButton.requestFocus();
            }
        });
        this.pack();
    }

    private void changeFolder(File folder) {
        if (folder == null) {
            Alert.showLocError("newfolder.select.error");
            return;
        }
        File currentFolder = MinecraftUtil.getWorkingDirectory();
        if (folder.getAbsolutePath().startsWith(currentFolder.getAbsolutePath())) {
            Alert.showLocError("newfolder.select.error.title", "newfolder.select.error.inside", null);
            return;
        }
        this.t.getSettings().set("minecraft.gamedir", folder.getAbsolutePath());
        LOGGER.info("User selected new game folder using NewFolderFrame: {}", (Object)folder);
        this.dispose();
    }

    public static boolean shouldWeMoveFrom(File currentDir) {
        if (currentDir == null) {
            return true;
        }
        if (!currentDir.isDirectory()) {
            try {
                FileUtil.createFolder(currentDir);
            }
            catch (Exception e) {
                LOGGER.warn("Not accessible: {}", (Object)currentDir);
                currentDir.delete();
                return true;
            }
            return false;
        }
        if (!(currentDir.canRead() && currentDir.canWrite() && currentDir.canExecute())) {
            LOGGER.warn("Is either not readable/writable/executable: {}", (Object)currentDir);
            return true;
        }
        File[] list = currentDir.listFiles();
        if (list == null) {
            LOGGER.warn("Couldn't list files (returned null) in {}", (Object)currentDir);
            return true;
        }
        if (list.length == 0) {
            return false;
        }
        File profileFile = new File(currentDir, "tlauncher_profiles.json");
        if (profileFile.isFile()) {
            LOGGER.warn("Contains profile file: {}", (Object)profileFile);
            return false;
        }
        return true;
    }

    public static File selectDestination() {
        ArrayList<File> suggestions = new ArrayList<File>();
        if (OS.WINDOWS.isCurrent()) {
            suggestions.addAll(Arrays.asList(new File("D:\\Games\\Minecraft"), new File("C:\\Games\\Minecraft")));
        }
        suggestions.addAll(Collections.singletonList(MinecraftUtil.getSystemRelatedDirectory("minecraft")));
        suggestions.addAll(Arrays.asList(MinecraftUtil.getSystemRelatedDirectory("Minecraft", false), MinecraftUtil.getSystemRelatedDirectory("tlauncher/" + TLauncher.getShortBrand())));
        for (File suggestion : suggestions) {
            if (NewFolderFrame.shouldWeMoveFrom(suggestion)) continue;
            return suggestion;
        }
        return null;
    }
}

