/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.frames;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.configuration.LangConfiguration;
import ru.turikhay.tlauncher.ui.converter.LocaleConverter;
import ru.turikhay.tlauncher.ui.frames.VActionFrame;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.support.ContributorsAlert;
import ru.turikhay.tlauncher.ui.swing.MagnifiedInsets;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedComboBox;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.ui.swing.extended.VPanel;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.U;

public class FirstRunNotice
extends VActionFrame {
    private final TLauncher t = TLauncher.getInstance();
    private FirstRunNotice parent;
    private boolean localeUpdated;

    public FirstRunNotice() {
        super(SwingUtil.magnify(500));
        this.setTitlePath("firstrun.title", new Object[0]);
        this.setDefaultCloseOperation(3);
        this.getHead().setText("firstrun.notice.welcome");
        VPanel list = new VPanel();
        list.setInsets(new MagnifiedInsets(0, 10, 0, 0));
        for (int i = 0; i < 3; ++i) {
            VActionFrame.VActionBody label = new VActionFrame.VActionBody(this);
            label.setText("firstrun.notice.body." + i);
            list.add((Component)label);
        }
        this.getBodyText().setText("firstrun.notice.body");
        this.getBody().add((Component)list);
        this.getFooter().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = -1;
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        ExtendedComboBox<Locale> localeChoose = new ExtendedComboBox<Locale>(new LocaleConverter(){

            @Override
            public String toString(Locale from) {
                return this.toString(from, Locale.US);
            }
        });
        for (Locale locale : LangConfiguration.getAvailableLocales()) {
            localeChoose.addItem(locale);
        }
        localeChoose.setSelectedValue(this.t.getLang().getLocale());
        localeChoose.addItemListener(e -> {
            Locale selected = (Locale)localeChoose.getSelectedValue();
            if (selected == null) {
                selected = Locale.US;
            }
            this.t.getSettings().set("locale", selected);
            this.t.getLang().setLocale(selected);
            this.updateLocale();
            ContributorsAlert.showAlert();
        });
        this.getFooter().add(localeChoose, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.getFooter().add((Component)new ExtendedPanel(), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        LocalizableButton yesButton = new LocalizableButton("firstrun.notice.answer.yes");
        yesButton.setPreferredSize(SwingUtil.magnify(new Dimension(150, 40)));
        yesButton.addActionListener(e -> this.dispose());
        this.getFooter().add((Component)yesButton, c);
        this.updateLocale();
        this.pack();
        ContributorsAlert.showAlert();
    }

    private void showLocaleUpdated(FirstRunNotice parent) {
        this.parent = parent;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (!FirstRunNotice.this.localeUpdated) {
                    FirstRunNotice p = FirstRunNotice.this;
                    while (p.parent != null) {
                        p = p.parent;
                    }
                    p.localeUpdated = false;
                }
            }
        });
        this.showAtCenter();
    }

    @Override
    public void showAndWait() {
        this.showAtCenter();
        while (this.isDisplayable() || this.localeUpdated) {
            U.sleepFor(100L);
        }
    }

    @Override
    public void updateLocale() {
        if (this.isDisplayable()) {
            this.localeUpdated = true;
            this.dispose();
            FirstRunNotice f = new FirstRunNotice();
            f.showLocaleUpdated(this);
        }
    }
}

