/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.explorer;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.filechooser.FileFilter;
import ru.turikhay.tlauncher.ui.explorer.FileExplorer;
import ru.turikhay.util.FileUtil;

public abstract class FilteredFileExplorer
extends FileExplorer {
    private final List<String> extensionList = new ArrayList<String>();

    protected FilteredFileExplorer() {
        this.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String extension = FileUtil.getExtension(f);
                return extension == null || FilteredFileExplorer.this.extensionList.contains(extension);
            }

            @Override
            public String getDescription() {
                return FilteredFileExplorer.this.getDescription();
            }
        });
        this.setAcceptAllFileFilterUsed(false);
    }

    protected abstract String getDescription();

    protected void addExtesion(String ... ext) {
        this.extensionList.addAll(Arrays.stream(ext).filter(Objects::nonNull).collect(Collectors.toList()));
    }
}

