/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.explorer;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.util.OS;

public class FileExplorer
extends JFileChooser {
    private static final Logger LOGGER = LogManager.getLogger(FileExplorer.class);

    @Override
    public void setCurrentDirectory(File dir) {
        if (dir == null) {
            dir = this.getFileSystemView().getDefaultDirectory();
        }
        super.setCurrentDirectory(dir);
    }

    public void setCurrentDirectory(String sDir) {
        File dir = sDir == null ? null : new File(sDir);
        this.setCurrentDirectory(dir);
    }

    public int showDialog(Component parent) {
        return this.showDialog(parent, UIManager.getString("FileChooser.directoryOpenButtonText"));
    }

    @Override
    public File[] getSelectedFiles() {
        File[] fileArray;
        File[] selectedFiles = super.getSelectedFiles();
        if (selectedFiles.length > 0) {
            return selectedFiles;
        }
        File selectedFile = super.getSelectedFile();
        if (selectedFile == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = selectedFile;
        }
        return fileArray;
    }

    public static FileExplorer newExplorer() throws Exception {
        try {
            return new FileExplorer();
        }
        catch (Throwable var1) {
            throw new Exception("couldn't create explorer", var1);
        }
    }

    public static String normalize(String path) {
        if (!OS.WINDOWS.isCurrent() || StringUtils.isEmpty((CharSequence)path) || !Character.isWhitespace(path.charAt(path.length() - 1))) {
            return path;
        }
        LOGGER.debug("Stripping whitespace chars: \"{}\"", (Object)path);
        return StringUtils.stripEnd((String)path, null);
    }
}

