/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.editor;

import javax.swing.text.Document;
import ru.turikhay.tlauncher.ui.editor.EditorField;
import ru.turikhay.tlauncher.ui.loc.LocalizableTextField;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;

public class EditorTextField
extends BorderPanel
implements EditorField {
    private static final long serialVersionUID = 3920711425159165958L;
    private final boolean canBeEmpty;
    public final LocalizableTextField textField;

    public EditorTextField(String prompt, boolean canBeEmpty) {
        this.canBeEmpty = canBeEmpty;
        this.textField = new LocalizableTextField(prompt){

            @Override
            protected void updateStyle() {
            }
        };
        this.textField.setColumns(1);
        this.setCenter(this.textField);
    }

    public EditorTextField(String prompt) {
        this(prompt, false);
    }

    public EditorTextField(boolean canBeEmpty) {
        this((String)null, canBeEmpty);
    }

    public EditorTextField() {
        this(false);
    }

    @Override
    public String getSettingsValue() {
        return this.textField.getValue();
    }

    @Override
    public void setSettingsValue(String value) {
        this.textField.setText(value);
        this.textField.setCaretPosition(0);
    }

    @Override
    public boolean isValueValid() {
        String text = this.textField.getValue();
        return text != null || this.canBeEmpty;
    }

    public Document getDocument() {
        return this.textField.getDocument();
    }

    @Override
    public void block(Object reason) {
        this.textField.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.textField.setEnabled(true);
    }
}

