/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.editor.EditorField;
import ru.turikhay.tlauncher.ui.editor.EditorIntegerField;
import ru.turikhay.tlauncher.ui.loc.LocalizableHTMLLabel;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedLabel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.util.IntegerArray;

public class EditorResolutionField
extends BorderPanel
implements EditorField {
    private static final long serialVersionUID = -5565607141889620750L;
    private final EditorIntegerField w;
    private final EditorIntegerField h;

    public EditorResolutionField(String promptW, String promptH, int[] defaults, boolean showDefault) {
        if (defaults == null) {
            throw new NullPointerException();
        }
        if (defaults.length != 2) {
            throw new IllegalArgumentException("Illegal array size");
        }
        ExtendedPanel container = new ExtendedPanel();
        container.setAlignmentX(0.5f);
        container.setAlignmentY(0.5f);
        this.w = new EditorIntegerField(promptW);
        this.w.textField.setColumns(4);
        this.w.textField.setHorizontalAlignment(0);
        this.h = new EditorIntegerField(promptH);
        this.h.textField.setColumns(4);
        this.h.textField.setHorizontalAlignment(0);
        ExtendedLabel x = new ExtendedLabel("X", 0);
        container.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.gridx = 0;
        c.weightx = 0.5;
        c.insets.set(0, 0, 0, 0);
        c.fill = 1;
        container.add((Component)this.w, c);
        c.gridx = 1;
        c.weightx = 0.0;
        c.insets.set(0, 5, 0, 5);
        c.fill = 3;
        container.add((Component)x, c);
        c.gridx = 2;
        c.weightx = 0.5;
        c.insets.set(0, 0, 0, 0);
        c.fill = 1;
        container.add((Component)this.h, c);
        this.setCenter(container);
        LocalizableHTMLLabel hint = new LocalizableHTMLLabel("settings.res.def", defaults[0], defaults[1]);
        hint.setFont(hint.getFont().deriveFont((float)hint.getFont().getSize() - 2.0f));
        if (showDefault) {
            this.setSouth(hint);
        }
    }

    @Override
    public String getSettingsValue() {
        return this.w.getSettingsValue() + ';' + this.h.getSettingsValue();
    }

    int[] getResolution() {
        try {
            IntegerArray e = IntegerArray.parseIntegerArray(this.getSettingsValue());
            return e.toArray();
        }
        catch (Exception var2) {
            return new int[2];
        }
    }

    @Override
    public boolean isValueValid() {
        int[] size = this.getResolution();
        return size[0] >= 1 && size[1] >= 1;
    }

    @Override
    public void setSettingsValue(String value) {
        String height;
        String width;
        try {
            IntegerArray e = IntegerArray.parseIntegerArray(value);
            width = String.valueOf(e.get(0));
            height = String.valueOf(e.get(1));
        }
        catch (Exception var5) {
            width = "";
            height = "";
        }
        this.w.textField.setText(width);
        this.h.textField.setText(height);
    }

    @Override
    public void setBackground(Color bg) {
        if (this.w != null) {
            this.w.setBackground(bg);
        }
        if (this.h != null) {
            this.h.setBackground(bg);
        }
    }

    @Override
    public void block(Object reason) {
        Blocker.blockComponents(reason, this.w, this.h);
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblockComponents(Blocker.UNIVERSAL_UNBLOCK, this.w, this.h);
    }
}

