/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import ru.turikhay.tlauncher.ui.editor.EditorHandler;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;

public class EditorPair {
    private final LocalizableLabel label;
    private final List<? extends EditorHandler> handlers;
    private final ExtendedPanel panel;
    public static final EditorHandler NEXT_COLUMN = new NextColumn();

    public EditorPair(String labelPath, List<? extends EditorHandler> handlers) {
        this.handlers = handlers;
        this.label = new LocalizableLabel(labelPath);
        this.panel = new ExtendedPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridy = -1;
        EditorHandler prev = null;
        for (EditorHandler editorHandler : handlers) {
            if (NEXT_COLUMN.equals(editorHandler)) {
                ++c.gridx;
                prev = editorHandler;
                continue;
            }
            if (!NEXT_COLUMN.equals(prev)) {
                c.gridx = 0;
                ++c.gridy;
            }
            JComponent comp = editorHandler.getComponent();
            comp.setAlignmentX(0.0f);
            this.panel.add((Component)comp, c);
            prev = editorHandler;
        }
    }

    public EditorPair(String labelPath, EditorHandler ... handlers) {
        this(labelPath, Arrays.asList(handlers));
    }

    public List<? extends EditorHandler> getHandlers() {
        return this.handlers;
    }

    public LocalizableLabel getLabel() {
        return this.label;
    }

    public ExtendedPanel getPanel() {
        return this.panel;
    }

    private static class NextColumn
    extends EditorHandler {
        private NextColumn() {
            super(null);
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public JComponent getComponent() {
            return null;
        }

        @Override
        public String getValue() {
            return null;
        }

        @Override
        protected void setValue0(String var1) {
        }

        @Override
        public void block(Object var1) {
        }

        @Override
        public void unblock(Object var1) {
        }
    }
}

