/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ru.turikhay.tlauncher.ui.editor.EditorFieldChangeListener;
import ru.turikhay.tlauncher.ui.editor.EditorFieldListener;
import ru.turikhay.tlauncher.ui.editor.EditorHandler;

public class EditorGroupHandler {
    private final List<EditorFieldChangeListener> listeners;
    private final int checkedLimit;
    private int changedFlag;
    private int checkedFlag;

    public EditorGroupHandler(List<? extends EditorHandler> handlers) {
        if (handlers == null) {
            throw new NullPointerException();
        }
        this.checkedLimit = handlers.size();
        EditorFieldListener listener = new EditorFieldListener(){

            @Override
            protected void onChange(EditorHandler handler, String oldValue, String newValue) {
                if (newValue != null) {
                    if (!newValue.equals(oldValue)) {
                        EditorGroupHandler.this.changedFlag = EditorGroupHandler.this.changedFlag + 1;
                    }
                    EditorGroupHandler.this.checkedFlag = EditorGroupHandler.this.checkedFlag + 1;
                    if (EditorGroupHandler.this.checkedFlag == EditorGroupHandler.this.checkedLimit) {
                        if (EditorGroupHandler.this.changedFlag > 0) {
                            for (EditorFieldChangeListener listener : EditorGroupHandler.this.listeners) {
                                listener.onChange(null, null);
                            }
                        }
                        EditorGroupHandler var10000 = EditorGroupHandler.this;
                        EditorGroupHandler.this.changedFlag = 0;
                        var10000.checkedFlag = 0;
                    }
                }
            }
        };
        for (int i = 0; i < handlers.size(); ++i) {
            EditorHandler handler = handlers.get(i);
            if (handler == null) {
                throw new NullPointerException("Handler is NULL at " + i);
            }
            handler.addListener(listener);
        }
        this.listeners = Collections.synchronizedList(new ArrayList());
    }

    public EditorGroupHandler(EditorHandler ... handlers) {
        this(Arrays.asList(handlers));
    }

    public boolean addListener(EditorFieldChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return this.listeners.add(listener);
    }

    public boolean removeListener(EditorFieldChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return this.listeners.remove(listener);
    }
}

