/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.editor;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.function.Consumer;
import javax.swing.event.DocumentEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.editor.EditorField;
import ru.turikhay.tlauncher.ui.editor.EditorTextField;
import ru.turikhay.tlauncher.ui.explorer.FileExplorer;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.swing.DocumentChangeListener;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;

public class EditorFileField
extends BorderPanel
implements EditorField {
    private static final Logger LOGGER = LogManager.getLogger(EditorFileField.class);
    private static final String DEFAULT_BUTTON_PATH = "explorer.browse";
    protected final EditorTextField textField;
    private final LocalizableButton explorerButton;
    private final FileExplorer explorer;
    private final boolean permitUrl;

    public EditorFileField(String prompt, String buttonPath, FileExplorer exp, boolean canBeEmpty, boolean permitUrl) {
        this.permitUrl = permitUrl;
        this.textField = new EditorTextField(prompt, canBeEmpty);
        this.explorerButton = new LocalizableButton(buttonPath);
        this.explorerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorFileField.this.explorer == null) {
                    return;
                }
                EditorFileField.this.explorerButton.setEnabled(false);
                EditorFileField.this.explorer.setCurrentDirectory(EditorFileField.this.getSelectedFile());
                int result = EditorFileField.this.explorer.showDialog(EditorFileField.this);
                if (result == 0) {
                    String path;
                    File selected = EditorFileField.this.explorer.getSelectedFile();
                    if (selected == null) {
                        path = "";
                    } else {
                        try {
                            path = selected.getCanonicalPath();
                        }
                        catch (Exception ex) {
                            path = selected.getAbsolutePath();
                            LOGGER.warn("Couldn't get canonical path. Will use absolute path: {} -> {}", (Object)selected, (Object)path, (Object)ex);
                        }
                    }
                    EditorFileField.this.setSettingsValue(path);
                }
                EditorFileField.this.explorerButton.setEnabled(true);
            }
        });
        this.explorer = exp;
        this.setCenter(this.textField);
        if (this.explorer != null) {
            this.setEast(this.explorerButton);
        }
    }

    public EditorFileField(String prompt, FileExplorer exp, boolean canBeEmpty, boolean permitUrl) {
        this(prompt, DEFAULT_BUTTON_PATH, exp, canBeEmpty, permitUrl);
    }

    public File getSelectedFile() {
        File selected = null;
        if (this.getSettingsValue() != null && EditorFileField.parseUrl(this.getSettingsValue()) == null) {
            selected = new File(this.getSettingsValue());
        } else if (this.explorer != null) {
            selected = this.explorer.getSelectedFile();
        }
        return selected == null ? new File(".") : selected;
    }

    @Override
    public void setBackground(Color bg) {
        if (this.textField != null) {
            this.textField.setBackground(bg);
        }
    }

    @Override
    public String getSettingsValue() {
        URL testUrl;
        String value = this.textField.getSettingsValue();
        try {
            testUrl = new URL(value);
        }
        catch (Exception e) {
            return FileExplorer.normalize(value);
        }
        return testUrl.toString();
    }

    @Override
    public void setSettingsValue(String var) {
        this.textField.setSettingsValue(var);
    }

    @Override
    public boolean isValueValid() {
        if (!this.permitUrl && EditorFileField.parseUrl(this.getSettingsValue()) != null) {
            return false;
        }
        return this.textField.isValueValid();
    }

    @Override
    public void block(Object reason) {
        Blocker.blockComponents(reason, this.textField, this.explorerButton);
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblockComponents(Blocker.UNIVERSAL_UNBLOCK, this.textField, this.explorerButton);
    }

    private static URL parseUrl(String s) {
        URL testUrl;
        try {
            testUrl = new URL(s);
        }
        catch (Exception e) {
            return null;
        }
        return testUrl;
    }

    public void addChangeListener(final Consumer<String> listener) {
        this.textField.getDocument().addDocumentListener(new DocumentChangeListener(){

            @Override
            public void documentChanged(DocumentEvent e) {
                listener.accept(EditorFileField.this.textField.getSettingsValue());
            }
        });
    }
}

