/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.editor;

import ru.turikhay.tlauncher.ui.converter.StringConverter;
import ru.turikhay.tlauncher.ui.editor.EditorField;
import ru.turikhay.tlauncher.ui.swing.ConverterCellRenderer;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedComboBox;

public class EditorComboBox<T>
extends ExtendedComboBox<T>
implements EditorField {
    private static final long serialVersionUID = -2320340434786516374L;
    private final boolean allowNull;

    public EditorComboBox(ConverterCellRenderer<T> renderer, boolean allowNull) {
        super(renderer);
        this.setConverter(renderer.getConverter());
        this.allowNull = allowNull;
    }

    public EditorComboBox(StringConverter<T> converter, T[] values, boolean allowNull) {
        super(converter);
        this.allowNull = allowNull;
        if (values != null) {
            for (T value : values) {
                this.addItem(value);
            }
        }
    }

    public EditorComboBox(StringConverter<T> converter, T[] values) {
        this(converter, values, false);
    }

    @Override
    public String getSettingsValue() {
        Object value = this.getSelectedValue();
        return this.convert(value);
    }

    @Override
    public void setSettingsValue(String string) {
        Object value = this.convert(string);
        if (!this.allowNull && string == null) {
            boolean hasNull = false;
            for (int i = 0; i < this.getItemCount(); ++i) {
                if (this.getItemAt(i) != null) continue;
                hasNull = true;
            }
            if (!hasNull) {
                return;
            }
        }
        this.setSelectedValue(value);
    }

    @Override
    public boolean isValueValid() {
        return true;
    }

    @Override
    public void block(Object reason) {
        this.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }
}

