/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.editor;

import ru.turikhay.tlauncher.ui.editor.EditorField;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableCheckbox;

public class EditorCheckBox
extends LocalizableCheckbox
implements EditorField {
    private final String path;
    private final boolean hint;

    public EditorCheckBox(String path, boolean hint) {
        super(path);
        this.path = path;
        this.hint = hint;
        this.updateHint();
    }

    public EditorCheckBox(String path) {
        this(path, false);
    }

    @Override
    public String getSettingsValue() {
        return this.isSelected() ? "true" : "false";
    }

    @Override
    public void setSettingsValue(String value) {
        this.setSelected(Boolean.parseBoolean(value));
    }

    @Override
    public boolean isValueValid() {
        return true;
    }

    @Override
    public void block(Object reason) {
        this.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }

    @Override
    public void updateLocale() {
        super.updateLocale();
        this.updateHint();
    }

    private void updateHint() {
        if (this.hint) {
            this.setToolTipText(Localizable.get(this.path + ".hint"));
        }
    }
}

