/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.editor;

import java.awt.Color;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import ru.turikhay.tlauncher.ui.center.CenterPanel;
import ru.turikhay.tlauncher.ui.center.CenterPanelTheme;
import ru.turikhay.tlauncher.ui.editor.EditorHandler;
import ru.turikhay.tlauncher.ui.images.ImageIcon;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;

public abstract class AbstractEditorPanel
extends CenterPanel {
    protected final List<EditorHandler> handlers = new ArrayList<EditorHandler>();

    public AbstractEditorPanel(CenterPanelTheme theme, Insets insets) {
        super(theme, insets);
    }

    public AbstractEditorPanel(Insets insets) {
        this(null, insets);
    }

    public AbstractEditorPanel() {
        this(null, null);
    }

    protected boolean checkValues() {
        boolean allValid = true;
        for (EditorHandler handler : this.handlers) {
            boolean valid = handler.isValid();
            this.setValid(handler, valid);
            if (valid) continue;
            allValid = false;
        }
        return allValid;
    }

    protected void setValid(EditorHandler handler, boolean valid) {
        Color color;
        Color color2 = color = valid ? this.getTheme().getBackground() : this.getTheme().getFailure();
        if (handler.getComponent() != null) {
            handler.getComponent().setOpaque(!valid);
            handler.getComponent().setBackground(color);
        }
    }

    protected JComponent createTip(String label, boolean warning) {
        LocalizableLabel tip = new LocalizableLabel(label);
        if (warning) {
            ImageIcon.setup(tip, Images.getIcon16("warning"));
        }
        return tip;
    }
}

