/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.crash;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.Locale;
import java.util.Objects;
import javax.swing.ImageIcon;
import net.minecraft.launcher.updater.VersionSyncInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.logger.Log4j2ContextHelper;
import ru.turikhay.tlauncher.minecraft.crash.Crash;
import ru.turikhay.tlauncher.minecraft.crash.CrashEntry;
import ru.turikhay.tlauncher.ui.frames.VActionFrame;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.support.PreSupportFrame;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedButton;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;

public final class CrashFrame
extends VActionFrame {
    private static final Logger LOGGER = LogManager.getLogger(CrashFrame.class);
    private final ru.turikhay.tlauncher.ui.images.ImageIcon crashIcon = Images.getIcon32("bug");
    private final PreSupportFrame supportFrame = new PreSupportFrame(){

        @Override
        protected void onContinued() {
            super.onContinued();
            CrashFrame.this.setVisible(false);
        }
    };
    private Crash crash;
    private final LocalizableButton openLogs = new LocalizableButton("crash.buttons.logs");
    private final LocalizableButton askHelp;
    private final LocalizableButton exitButton;

    CrashFrame() {
        this.openLogs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File logFile;
                if (CrashFrame.this.crash.getManager().hasProcessLogger()) {
                    logFile = CrashFrame.this.crash.getManager().getProcessLogger().getLogFile().getFile();
                } else {
                    LOGGER.warn("Opening logs, but CrashManager had no process logger");
                    logFile = Log4j2ContextHelper.getCurrentLogFile().getFile();
                }
                OS.openFile(logFile);
            }
        });
        this.askHelp = new LocalizableButton("crash.buttons.support");
        this.askHelp.addActionListener(e -> this.supportFrame.showAtCenter());
        this.exitButton = new LocalizableButton("crash.buttons.exit");
        this.askHelp.setPreferredSize(SwingUtil.magnify(new Dimension(150, 25)));
        this.exitButton.setPreferredSize(SwingUtil.magnify(new Dimension(150, 25)));
        this.exitButton.addActionListener(e -> this.setVisible(false));
        this.getFooter().setLayout(new GridBagLayout());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (TLauncher.getInstance().getSettings().getActionOnLaunch() == Configuration.ActionOnLaunch.EXIT) {
                    TLauncher.kill();
                }
            }
        });
    }

    public Crash getCrash() {
        return this.crash;
    }

    public void setCrash(Crash crash) {
        this.crash = Objects.requireNonNull(crash);
        if (crash.getEntry() == null) {
            this.initOnUnknown();
        } else {
            if (crash.getEntry().isFake()) {
                return;
            }
            this.initOnCrash(crash.getEntry());
        }
        this.pack();
        this.showAtCenter();
    }

    private void initOnUnknown() {
        LOGGER.debug("Unknown crash proceeded");
        this.setTitlePath("crash.unknown.title", new Object[0]);
        this.getHead().setText("crash.unknown.title");
        this.getHead().setIcon(this.crashIcon);
        this.getBodyText().setText("crash.unknown.body");
        this.setButtons(true, new ExtendedButton[0]);
    }

    private void initOnCrash(CrashEntry entry) {
        LOGGER.debug("Crash entry proceeded: {}", (Object)entry);
        this.setTitlePath(entry.getTitle(), entry.getTitleVars());
        if (entry.getImage() != null) {
            Image image = null;
            try {
                image = SwingUtil.loadImage(entry.getImage());
            }
            catch (Exception e) {
                LOGGER.warn("could not load crash image {}", (Object)entry.getImage(), (Object)e);
            }
            if (image != null) {
                this.getHead().setIcon(new ImageIcon(image));
            }
        } else {
            this.getHead().setIcon(this.crashIcon);
        }
        this.getHead().setText(entry.getTitle(), entry.getTitleVars());
        this.getBodyText().setText(entry.getBody(), entry.getBodyVars());
        ExtendedButton[] graphicsButtons = new ExtendedButton[entry.getButtons().size()];
        for (int i = 0; i < entry.getButtons().size(); ++i) {
            graphicsButtons[i] = entry.getButtons().get(i).toGraphicsButton(entry);
        }
        this.setButtons(entry.isPermitHelp(), graphicsButtons);
    }

    private void setButtons(boolean askHelp, ExtendedButton ... buttons) {
        this.getFooter().removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = SwingUtil.magnify(new Insets(0, 5, 0, 5));
        c.gridx = -1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 21;
        c.fill = 1;
        for (ExtendedButton button : buttons) {
            ++c.gridx;
            button.setPreferredSize(new Dimension(button.getMinimumSize().width, SwingUtil.magnify(60)));
            this.getFooter().add((Component)button, c);
        }
        if (askHelp) {
            if (this.isProbablyBadVersionCrashed()) {
                LOGGER.info("Custom local version is crashed. Disabling help offer.");
            } else {
                ++c.gridx;
                this.askHelp.setPreferredSize(new Dimension(this.askHelp.getMinimumSize().width, SwingUtil.magnify(60)));
                this.getFooter().add((Component)this.askHelp, c);
            }
        }
        ExtendedPanel buttonPanel = new ExtendedPanel();
        buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints c0 = new GridBagConstraints();
        c0.insets = SwingUtil.magnify(new Insets(2, 0, 2, 0));
        c0.gridx = 0;
        c0.gridy = -1;
        c0.weightx = 0.0;
        c0.weighty = 1.0;
        c0.anchor = 21;
        c0.fill = 1;
        ++c0.gridy;
        buttonPanel.add((Component)this.openLogs, c0);
        ++c0.gridy;
        buttonPanel.add((Component)this.exitButton, c0);
        c.weightx = 0.0;
        ++c.gridx;
        this.getFooter().add((Component)buttonPanel, c);
    }

    private boolean isProbablyBadVersionCrashed() {
        VersionSyncInfo versionSyncInfo;
        String versionId = this.crash.getManager().getLauncher().getVersion();
        if (versionId.toLowerCase(Locale.ROOT).contains("forge") || versionId.toLowerCase(Locale.ROOT).contains("fabric")) {
            return false;
        }
        try {
            versionSyncInfo = Objects.requireNonNull(TLauncher.getInstance().getVersionManager().getVersionSyncInfo(versionId));
        }
        catch (RuntimeException rE) {
            LOGGER.warn("Couldn't detect if this crash is occurred in the custom version", (Throwable)rE);
            return false;
        }
        return !versionSyncInfo.hasRemote();
    }
}

