/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.converter;

import java.util.Locale;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.ReleaseType;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableStringConverter;

public class VersionConverter
extends LocalizableStringConverter<VersionSyncInfo> {
    private static final VersionSyncInfo LOADING = VersionSyncInfo.createEmpty();
    private static final VersionSyncInfo EMPTY = VersionSyncInfo.createEmpty();
    private final VersionManager vm;

    public VersionConverter(VersionManager vm) {
        super(null);
        if (vm == null) {
            throw new NullPointerException();
        }
        this.vm = vm;
    }

    @Override
    public String toString(VersionSyncInfo from) {
        if (from == null) {
            return null;
        }
        if (from.equals(LOADING)) {
            return Localizable.get("versions.loading");
        }
        if (from.equals(EMPTY)) {
            return Localizable.get("versions.notfound.tip");
        }
        String id = from.getID();
        ReleaseType type = from.getLatestVersion().getReleaseType();
        if (type != null && !type.equals((Object)ReleaseType.UNKNOWN)) {
            String typeF = type.toString().toLowerCase(Locale.ROOT);
            String formatted = Localizable.get().nget("version." + typeF, id);
            return formatted == null ? id : formatted;
        }
        return id;
    }

    @Override
    public VersionSyncInfo fromString(String from) {
        return this.vm.getVersionSyncInfo(from);
    }

    @Override
    public String toValue(VersionSyncInfo from) {
        return null;
    }

    @Override
    public String toPath(VersionSyncInfo from) {
        return null;
    }

    @Override
    public Class<VersionSyncInfo> getObjectClass() {
        return VersionSyncInfo.class;
    }
}

