/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.converter;

import java.io.File;
import java.util.Locale;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.VersionFamily;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.ui.loc.LocalizableStringConverter;

public class SeparateDirsConverter
extends LocalizableStringConverter<Configuration.SeparateDirs> {
    private final boolean useCurrentVersionHint;
    private static final String homeDirPrefix = "home" + File.separatorChar;

    public SeparateDirsConverter(boolean useCurrentVersionHint) {
        super("settings.client.gamedir.separatedirs");
        this.useCurrentVersionHint = useCurrentVersionHint;
    }

    @Override
    public Configuration.SeparateDirs fromString(String from) {
        return Configuration.SeparateDirs.get(from);
    }

    @Override
    public String toValue(Configuration.SeparateDirs from) {
        return from == null ? null : from.toString().toLowerCase(Locale.ROOT);
    }

    @Override
    public String toPath(Configuration.SeparateDirs from) {
        return from == null ? null : from.toString().toLowerCase(Locale.ROOT);
    }

    @Override
    public String toString(Configuration.SeparateDirs from) {
        return super.toString(from) + this.evaluateHintIfAvailable(from);
    }

    @Override
    public Class<Configuration.SeparateDirs> getObjectClass() {
        return Configuration.SeparateDirs.class;
    }

    private String evaluateHintIfAvailable(Configuration.SeparateDirs from) {
        if (!this.useCurrentVersionHint || from == null) {
            return "";
        }
        String hint = SeparateDirsConverter.evaluateBestEffortHint(from);
        return hint == null ? "" : " (" + hint + ")";
    }

    private static String evaluateBestEffortHint(Configuration.SeparateDirs mode) {
        if (mode == null || mode == Configuration.SeparateDirs.NONE || !TLauncher.getInstance().isReady()) {
            return null;
        }
        VersionSyncInfo versionSyncInfo = TLauncher.getInstance().getFrame().mp.defaultScene.loginForm.versions.getVersion();
        if (versionSyncInfo == null) {
            return null;
        }
        switch (mode) {
            case FAMILY: {
                VersionFamily.Guess guess = VersionFamily.guessFamilyOf(versionSyncInfo);
                return guess == null ? null : homeDirPrefix + guess.getFamily();
            }
            case VERSION: {
                return homeDirPrefix + versionSyncInfo.getAvailableVersion().getID();
            }
        }
        return null;
    }
}

