/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.background.fx;

import java.io.File;
import java.net.URL;
import javafx.animation.FadeTransition;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.NumberBinding;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.ui.background.IFXBackground;
import ru.turikhay.util.FileUtil;

public class MediaFxBackground
extends Pane
implements IFXBackground {
    private static final Logger LOGGER = LogManager.getLogger(MediaFxBackground.class);
    private final MediaView view = new MediaView();
    private final Rectangle rect;

    public MediaFxBackground() {
        this.view.setCache(true);
        this.view.setCacheHint(CacheHint.SPEED);
        this.rect = new Rectangle();
        this.sceneProperty().addListener(observable -> {
            Scene scene = this.getScene();
            this.prefWidthProperty().unbind();
            this.prefWidthProperty().bind((ObservableValue)scene.widthProperty());
            this.prefHeightProperty().unbind();
            this.prefHeightProperty().bind((ObservableValue)scene.heightProperty());
        });
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.rect.setFill((Paint)Color.BLACK);
        this.rect.widthProperty().bind((ObservableValue)this.widthProperty());
        this.rect.heightProperty().bind((ObservableValue)this.heightProperty());
        this.getChildren().addAll((Object[])new Node[]{this.view, this.rect});
    }

    @Override
    public void startBackground() {
        if (this.view.getMediaPlayer() != null) {
            LOGGER.debug("started");
            this.view.getMediaPlayer().play();
        }
    }

    @Override
    public void pauseBackground() {
        if (this.view.getMediaPlayer() != null) {
            LOGGER.debug("paused");
            this.view.getMediaPlayer().pause();
        }
    }

    @Override
    public void loadBackground(String path) throws Exception {
        this.view.setMediaPlayer(null);
        this.view.layoutXProperty().unbind();
        this.view.layoutYProperty().unbind();
        this.view.fitWidthProperty().unbind();
        this.view.fitHeightProperty().unbind();
        if (path == null) {
            throw new NullPointerException("path");
        }
        URL url = FileUtil.fileExists(path) ? new File(path).toURI().toURL() : new URL(path);
        LOGGER.debug("Loading media {}", (Object)url);
        Media media = new Media(url.toExternalForm());
        MediaPlayer player = new MediaPlayer(media);
        player.setMute(true);
        player.setCycleCount(-1);
        this.view.setMediaPlayer(player);
        player.setOnHalted(() -> {
            if (this.view.getMediaPlayer() != player) {
                return;
            }
            LOGGER.error("Error loading media {}", (Object)media, (Object)player.getError());
        });
        player.setOnReady(() -> {
            if (this.view.getMediaPlayer() != player) {
                return;
            }
            NumberBinding ratio = Bindings.min((ObservableNumberValue)media.widthProperty().divide((ObservableNumberValue)this.widthProperty()), (ObservableNumberValue)media.heightProperty().divide((ObservableNumberValue)this.heightProperty()));
            NumberBinding width = media.widthProperty().divide((ObservableNumberValue)ratio);
            NumberBinding height = media.heightProperty().divide((ObservableNumberValue)ratio);
            NumberBinding x = Bindings.subtract((ObservableNumberValue)this.widthProperty(), (ObservableNumberValue)width).divide(2.0);
            NumberBinding y = Bindings.subtract((ObservableNumberValue)this.heightProperty(), (ObservableNumberValue)height).divide(2.0);
            this.view.layoutXProperty().bind((ObservableValue)x);
            this.view.layoutYProperty().bind((ObservableValue)y);
            this.view.fitWidthProperty().bind((ObservableValue)width);
            this.view.fitHeightProperty().bind((ObservableValue)height);
            FadeTransition transition = new FadeTransition();
            transition.setNode((Node)this.rect);
            transition.setDuration(Duration.millis((double)250.0));
            transition.setToValue(0.0);
            transition.play();
            player.play();
        });
        if (player.getStatus() == MediaPlayer.Status.HALTED) {
            LOGGER.error("Could not load media {}", (Object)media.getSource(), (Object)player.getError());
        }
    }
}

