/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.background;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.handlers.ExceptionHandler;
import ru.turikhay.tlauncher.ui.background.BackgroundManager;
import ru.turikhay.tlauncher.ui.background.IBackground;
import ru.turikhay.util.U;

class Worker {
    private static final Logger LOGGER = LogManager.getLogger(Worker.class);
    private static final float STEP = 0.025f;
    private final ExecutorService service = Executors.newSingleThreadExecutor();
    private final CoverTask showBackgroundTask = new CoverTask(0.0f);
    private final CoverTask hideBackgroundTask = new CoverTask(1.0f);
    private final BackgroundManager wrapper;

    Worker(BackgroundManager wrapper) {
        this.wrapper = wrapper;
    }

    void showBackground() {
        this.submit(this.showBackgroundTask);
    }

    void hideBackground() {
        this.submit(this.hideBackgroundTask);
    }

    void setBackground(IBackground background, String path) {
        this.submit(new SetBackgroundTask(background, path));
    }

    private void submit(Runnable runnable, boolean requireAsync) {
        if (requireAsync || TLauncher.getInstance().isReady()) {
            this.service.submit(runnable);
        } else {
            runnable.run();
        }
    }

    private void submit(Runnable runnable) {
        this.submit(runnable, false);
    }

    private class CoverTask
    implements Runnable {
        final float targetOpacity;

        CoverTask(float targetOpacity) {
            this.targetOpacity = targetOpacity;
        }

        @Override
        public void run() {
            float opacity;
            if (!TLauncher.getInstance().isReady()) {
                ((Worker)Worker.this).wrapper.cover.setOpacity(this.targetOpacity);
                return;
            }
            if (this.targetOpacity == 0.0f) {
                U.sleepFor(1000L);
            }
            float step = (opacity = ((Worker)Worker.this).wrapper.cover.getOpacity()) > this.targetOpacity ? -0.025f : 0.025f;
            float eps = Math.abs(step / 2.0f);
            LOGGER.debug("setting opacity: {}, targetOpacity: {}, step: {}", (Object)Float.valueOf(opacity), (Object)Float.valueOf(this.targetOpacity), (Object)Float.valueOf(step));
            while (Math.abs(opacity - this.targetOpacity) > eps) {
                ((Worker)Worker.this).wrapper.cover.setOpacity(opacity += step);
                U.sleepFor(16L);
            }
            LOGGER.debug("opacity set to {}", (Object)Float.valueOf(this.targetOpacity));
        }
    }

    private class SetBackgroundTask
    implements Runnable {
        private final IBackground background;
        private final String path;

        private SetBackgroundTask(IBackground background, String path) {
            this.background = Objects.requireNonNull(background, "background");
            this.path = path;
        }

        @Override
        public void run() {
            Worker.this.hideBackgroundTask.run();
            Worker.this.wrapper.setBackground(this.background);
            try {
                this.background.loadBackground(this.path);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                ExceptionHandler.reduceMemory(outOfMemoryError);
            }
            catch (Exception e) {
                LOGGER.error("Could not load background for {}; path: {}", (Object)this.background, (Object)this.path, (Object)e);
            }
            Worker.this.showBackgroundTask.run();
        }
    }
}

