/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.background;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.ui.background.ISwingBackground;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.util.U;

public class OldAnimatedBackground
extends JComponent
implements ISwingBackground {
    private static final Logger LOGGER = LogManager.getLogger(OldAnimatedBackground.class);
    private static final long ONE_TICK_IN_MS = 1000L;
    private static final short DAY_CYCLE_IN_TICKS = 1200;
    private static final Color NIGHT_COLOR = Color.decode("#000221");
    private static final Color DAY_COLOR = Color.decode("#8dbde9");
    private static final Color SUNRISE_1 = new Color(227, 58, 58);
    private static final Color SUNRISE_2 = new Color(227, 175, 58);
    private static final Color SUN = new Color(255, 255, 255);
    private static final Color TRANSPARENT = new Color(255, 255, 255, 0);
    private final GrassImage grassImage;
    private final SkyColor skyColor;
    private final SunImage sunImage;
    private final StarsImage starsImage;
    private final DayCycle dayCycle = new DayCycle(OldAnimatedBackground.toTimeOfDay(Calendar.getInstance()));
    private TickTimer tickTimer;

    public OldAnimatedBackground() {
        this.grassImage = new GrassImage();
        this.skyColor = new SkyColor();
        this.sunImage = new SunImage();
        this.starsImage = new StarsImage();
    }

    private void startTickWorker() {
        if (this.tickTimer != null) {
            return;
        }
        this.tickTimer = new TickTimer(this::repaint);
        this.tickTimer.execute();
        LOGGER.debug("Tick worker started");
    }

    private void stopTickWorker() {
        if (this.tickTimer == null) {
            return;
        }
        this.tickTimer.cancel(true);
        this.tickTimer = null;
        LOGGER.debug("Tick worker stopped");
    }

    @Override
    public void paint(Graphics g0) {
        short currentTimeOfDay = this.dayCycle.timeOfDay;
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g = (Graphics2D)g0;
        BufferedImage scaledGrassImage = this.grassImage.get(currentTimeOfDay, width, height);
        int grassY = height - scaledGrassImage.getHeight();
        g.setPaint(this.skyColor.get(currentTimeOfDay));
        g.fillRect(0, 0, width, grassY);
        DaySegment segment = DaySegment.get(currentTimeOfDay);
        if (segment != DaySegment.AFTERNOON) {
            float starsOpacity;
            double completion = DaySegment.getSegmentCompletion(currentTimeOfDay);
            switch (segment) {
                case NIGHT: {
                    starsOpacity = 1.0f;
                    break;
                }
                case MORNING: {
                    starsOpacity = OldAnimatedBackground.transitionColor(1.0f, 0.0f, completion * 2.0);
                    break;
                }
                case DUSK: {
                    starsOpacity = OldAnimatedBackground.transitionColor(0.0f, 1.0f, completion);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            Composite oldComposite = g.getComposite();
            g.setComposite(AlphaComposite.SrcOver.derive(starsOpacity));
            g.drawImage((Image)this.starsImage.get(currentTimeOfDay, width, grassY * 2), 0, 0, null);
            g.setComposite(oldComposite);
        }
        g.drawImage((Image)this.sunImage.get(currentTimeOfDay, width, grassY * 2), this.sunImage.getSunX(currentTimeOfDay, width, grassY * 2), 0, null);
        for (int x = 0; x < width; x += scaledGrassImage.getWidth()) {
            g.drawImage((Image)scaledGrassImage, x, grassY, null);
        }
        if (TLauncher.getInstance() != null && TLauncher.getInstance().isDebug()) {
            g.setPaint(Color.GREEN);
            g.drawString(String.valueOf(currentTimeOfDay) + " " + (Object)((Object)DaySegment.get(currentTimeOfDay)) + " " + DaySegment.getSegmentCompletion(currentTimeOfDay), 0, 50);
        }
    }

    @Override
    public void onResize() {
        if (this.getParent() != null) {
            this.setSize(this.getParent().getSize());
        }
    }

    @Override
    public void startBackground() {
        this.startTickWorker();
    }

    @Override
    public void pauseBackground() {
        this.stopTickWorker();
    }

    @Override
    public void loadBackground(String path) {
    }

    static short toTimeOfDay(Calendar calendar) {
        return (short)(calendar.get(11) / 2 * 100 + calendar.get(12));
    }

    static Color transitionColor(Color oldColor, Color newColor, double progress) {
        return new Color(OldAnimatedBackground.transitionColor(oldColor.getRed(), newColor.getRed(), progress), OldAnimatedBackground.transitionColor(oldColor.getGreen(), newColor.getGreen(), progress), OldAnimatedBackground.transitionColor(oldColor.getBlue(), newColor.getBlue(), progress), OldAnimatedBackground.transitionColor(oldColor.getAlpha(), newColor.getAlpha(), progress));
    }

    static int transitionColor(int oldValue, int newValue, double progress) {
        if (progress < 0.0) {
            return oldValue;
        }
        if (progress > 1.0) {
            return newValue;
        }
        int value = (int)((double)oldValue + (double)(newValue - oldValue) * progress);
        if (value < 0) {
            return 0;
        }
        if (value > 255) {
            return 255;
        }
        return value;
    }

    static float transitionColor(float oldValue, float newValue, double progress) {
        if (progress < 0.0) {
            return oldValue;
        }
        if (progress > 1.0) {
            return newValue;
        }
        float value = (float)((double)oldValue + (double)(newValue - oldValue) * progress);
        if (value < 0.0f) {
            return 0.0f;
        }
        if (value > 1.0f) {
            return 1.0f;
        }
        return value;
    }

    static double transitionColor(double oldValue, double newValue, double progress) {
        if (progress < 0.0) {
            return oldValue;
        }
        if (progress > 1.0) {
            return newValue;
        }
        double value = oldValue + (newValue - oldValue) * progress;
        if (value < 0.0) {
            return 0.0;
        }
        if (value > 1.0) {
            return 1.0;
        }
        return value;
    }

    static int transition(int oldValue, int newValue, double progress) {
        if (progress < 0.0) {
            return oldValue;
        }
        if (progress > 1.0) {
            return newValue;
        }
        return (int)((double)oldValue + (double)(newValue - oldValue) * progress);
    }

    static class DayCycle {
        private short timeOfDay;

        DayCycle(short timeOfDay) {
            if (timeOfDay < 0 || timeOfDay >= 1200) {
                throw new IllegalArgumentException("timeOfDay: " + timeOfDay);
            }
            this.timeOfDay = timeOfDay;
        }

        void add(short ticks) {
            this.timeOfDay = DayCycle.normalize(this.timeOfDay + ticks);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DayCycle dayCycle = (DayCycle)o;
            return this.timeOfDay == dayCycle.timeOfDay;
        }

        public int hashCode() {
            return Objects.hash(this.timeOfDay);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("timeOfDay", this.timeOfDay).build();
        }

        static short normalize(long ticks) {
            short normalized = ticks < 0L || ticks >= 1200L ? (short)0 : (short)ticks;
            return normalized;
        }
    }

    static class GrassImage
    extends DynamicImage {
        private static final float NIGHT_COLOR_ALPHA = 0.6f;
        private final BufferedImage grassImage;
        private int scale;

        GrassImage() {
            this(Images.loadImageByName("grass.png"));
        }

        GrassImage(BufferedImage grassImage) {
            this.grassImage = Objects.requireNonNull(grassImage, "grassImage");
        }

        @Override
        BufferedImage generate(short timeOfDay, int width, int height) {
            int newGrassImageHeight = (int)((double)height / 2.0);
            int newGrassImageWidth = (int)((double)newGrassImageHeight / (double)this.grassImage.getHeight() * (double)this.grassImage.getWidth());
            this.scale = (int)((double)newGrassImageHeight / (double)this.grassImage.getHeight());
            BufferedImage newGrassImage = new BufferedImage(newGrassImageWidth, newGrassImageHeight, 1);
            this.draw(newGrassImage, timeOfDay);
            return newGrassImage;
        }

        int getScale() {
            return this.scale;
        }

        void draw(BufferedImage grassImage, short timeOfDay) {
            int width = grassImage.getWidth();
            int height = grassImage.getHeight();
            Graphics2D g = (Graphics2D)grassImage.getGraphics();
            g.drawImage(this.grassImage, 0, 0, width, height, null);
            switch (DaySegment.get(timeOfDay)) {
                case NIGHT: {
                    g.setComposite(AlphaComposite.SrcOver.derive(0.6f));
                    g.setPaint(NIGHT_COLOR);
                    g.fillRect(0, 0, width, height);
                    break;
                }
                case MORNING: {
                    g.setComposite(AlphaComposite.SrcOver.derive(0.6f - (float)(DaySegment.getSegmentCompletion(timeOfDay) * (double)0.6f)));
                    g.setPaint(NIGHT_COLOR);
                    g.fillRect(0, 0, width, height);
                    break;
                }
                case AFTERNOON: {
                    break;
                }
                case DUSK: {
                    g.setComposite(AlphaComposite.SrcOver.derive((float)DaySegment.getSegmentCompletion(timeOfDay) * 0.6f));
                    g.setPaint(NIGHT_COLOR);
                    g.fillRect(0, 0, width, height);
                }
            }
        }
    }

    static class SkyColor {
        SkyColor() {
        }

        Color get(short timeOfDay) {
            double completion = DaySegment.getSegmentCompletion(timeOfDay);
            switch (DaySegment.get(timeOfDay)) {
                case NIGHT: {
                    return NIGHT_COLOR;
                }
                case MORNING: {
                    return OldAnimatedBackground.transitionColor(NIGHT_COLOR, DAY_COLOR, completion * 2.0);
                }
                case AFTERNOON: {
                    return DAY_COLOR;
                }
                case DUSK: {
                    return OldAnimatedBackground.transitionColor(DAY_COLOR, NIGHT_COLOR, completion);
                }
            }
            throw new IllegalArgumentException();
        }
    }

    static class SunImage
    extends DynamicImage {
        SunImage() {
        }

        int getSunX(short timeOfDay, int width, int height) {
            double completion = DaySegment.getSegmentCompletion(timeOfDay);
            switch (DaySegment.get(timeOfDay)) {
                case NIGHT: {
                    return 0;
                }
                case MORNING: {
                    return OldAnimatedBackground.transition(-width / 3, 0, completion);
                }
                case AFTERNOON: {
                    return OldAnimatedBackground.transition(0, width / 2, completion);
                }
                case DUSK: {
                    return OldAnimatedBackground.transition(width / 2, width - width / 4, completion);
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        BufferedImage generate(short timeOfDay, int width, int height) {
            if (DaySegment.get(timeOfDay) == DaySegment.NIGHT) {
                return new BufferedImage(1, 1, 1);
            }
            BufferedImage image = new BufferedImage(height, height / 2, 2);
            this.draw(image, timeOfDay);
            return image;
        }

        void draw(BufferedImage image, short timeOfDay) {
            int flareY;
            double flareOpacity;
            int toY;
            int fromY;
            Color sunColor;
            int width = image.getWidth();
            int height = image.getHeight();
            Graphics2D g = (Graphics2D)image.getGraphics();
            int sunX = width / 6;
            int sunWidth = width / 3 * 2;
            int sunHeight = height / 2;
            double completion = DaySegment.getSegmentCompletion(timeOfDay);
            switch (DaySegment.get(timeOfDay)) {
                case MORNING: {
                    sunColor = completion < 0.5 ? OldAnimatedBackground.transitionColor(SUNRISE_1, SUNRISE_2, completion * 2.0) : OldAnimatedBackground.transitionColor(SUNRISE_2, SUN, (completion - 0.5) * 2.0);
                    fromY = height;
                    toY = height - sunHeight;
                    flareOpacity = OldAnimatedBackground.transitionColor(0.0, 1.0, completion * 10.0);
                    flareY = OldAnimatedBackground.transition(sunX, 0, completion);
                    break;
                }
                case AFTERNOON: {
                    sunColor = SUN;
                    fromY = height - sunHeight;
                    toY = height - sunHeight;
                    flareOpacity = 1.0;
                    flareY = 0;
                    break;
                }
                case DUSK: {
                    sunColor = completion < 0.5 ? OldAnimatedBackground.transitionColor(SUN, SUNRISE_2, completion * 2.0) : OldAnimatedBackground.transitionColor(SUNRISE_2, SUNRISE_1, (completion - 0.5) * 2.0);
                    fromY = height - sunHeight;
                    toY = height;
                    flareOpacity = 1.0 - completion;
                    flareY = OldAnimatedBackground.transition(0, sunHeight / 2, completion);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            int sunY = (int)((double)fromY + (double)(toY - fromY) * completion);
            g.setPaint(sunColor);
            g.fillRect(sunX, sunY, sunWidth, sunHeight);
            g.setPaint(OldAnimatedBackground.transitionColor(TRANSPARENT, U.shiftAlpha(sunColor, -127), flareOpacity));
            g.fillRect(sunX / 2, sunY / 2 + flareY, sunWidth + sunX, sunHeight + sunY + 1);
            g.setPaint(OldAnimatedBackground.transitionColor(TRANSPARENT, U.shiftAlpha(sunColor, -192), flareOpacity));
            g.fillRect(sunX / 4, sunY / 4 + flareY, sunWidth + sunX * 3 / 2, sunHeight + sunY + 1);
        }
    }

    static class StarsImage
    extends DynamicImage {
        private static final int STAR_RAND_BOUND = 200;
        private static final int STAR_RAND_GUESS = 0;
        private static final int SCALE_DIFF = 120;
        private static final int SCALE_MIN_ADD = 4;
        private final long seed;
        private final Random random;
        private final List<Star> stars = new ArrayList<Star>();

        StarsImage(long seed) {
            this.requireSameWorkspaceWidth = true;
            this.seed = seed;
            this.random = new Random(seed);
        }

        StarsImage() {
            this(System.currentTimeMillis());
        }

        @Override
        boolean needToRepaint(short newTimeOfDay) {
            return false;
        }

        private void generateStars(int width, int height, int scale) {
            this.random.setSeed(this.seed);
            this.stars.clear();
            for (int y = 0; y < height; y += scale) {
                for (int x = 0; x < width; x += scale) {
                    if (this.random.nextInt(200) != 0) continue;
                    this.stars.add(new Star(x, y, this.random.nextFloat()));
                }
            }
        }

        @Override
        BufferedImage generate(short timeOfDay, int width, int height) {
            int scale = height / 120 + 4;
            this.generateStars(width, height, scale);
            BufferedImage image = new BufferedImage(width, height / 2 + 1, 2);
            this.draw(image, scale);
            return image;
        }

        void draw(BufferedImage bufferedImage, int scale) {
            Graphics2D g = (Graphics2D)bufferedImage.getGraphics();
            for (Star star : this.stars) {
                g.setPaint(Color.WHITE);
                g.setComposite(AlphaComposite.SrcOver.derive(star.brightness));
                g.fillRect(star.x, star.y, scale, scale);
            }
        }

        static class Star {
            private final int x;
            private final int y;
            private final float brightness;

            public Star(int x, int y, float brightness) {
                this.x = x;
                this.y = y;
                this.brightness = brightness;
            }
        }
    }

    class TickTimer
    extends SwingWorker<Void, Void> {
        private final Runnable onUpdate;
        private long lastDayCycleUpdate;

        TickTimer(Runnable onUpdate) {
            this.onUpdate = Objects.requireNonNull(onUpdate, "onUpdate");
        }

        @Override
        protected Void doInBackground() {
            try {
                LOGGER.debug("First tick: {}", (Object)OldAnimatedBackground.this.dayCycle);
                this.lastDayCycleUpdate = System.currentTimeMillis();
                while (!this.isCancelled()) {
                    this.updateDayCycle();
                    this.onUpdate.run();
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException in) {
                LOGGER.debug("interrupted");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            LOGGER.debug("cancelled");
            return null;
        }

        private void updateDayCycle() {
            long currentTime = System.currentTimeMillis();
            long msDelta = currentTime - this.lastDayCycleUpdate;
            if (msDelta < 1000L) {
                return;
            }
            short deltaTicks = DayCycle.normalize(msDelta / 1000L);
            OldAnimatedBackground.this.dayCycle.add(deltaTicks);
            this.lastDayCycleUpdate = currentTime;
        }
    }

    static enum DaySegment {
        NIGHT,
        MORNING,
        AFTERNOON,
        DUSK;

        private static final DaySegment[] VALUES;
        static final short SEGMENT_LENGTH_IN_TICKS;
        private int segmentIndex;
        private short segmentStart;

        private static DaySegment getIndex(int index) {
            return VALUES[index];
        }

        private static int getSegmentIndex(short timeOfDay) {
            if (timeOfDay < SEGMENT_LENGTH_IN_TICKS) {
                return 0;
            }
            int index = timeOfDay / SEGMENT_LENGTH_IN_TICKS;
            return Math.min(index, VALUES.length - 1);
        }

        static DaySegment get(short timeOfDay) {
            return DaySegment.getIndex(DaySegment.getSegmentIndex(timeOfDay));
        }

        static double getSegmentCompletion(short timeOfDay) {
            DaySegment segment = DaySegment.get(timeOfDay);
            return (double)(timeOfDay - segment.segmentStart) / (double)SEGMENT_LENGTH_IN_TICKS;
        }

        static double getOverallCompletion(short timeOfDay) {
            if (timeOfDay < 0) {
                return 0.0;
            }
            return (double)timeOfDay / 1200.0;
        }

        static {
            VALUES = DaySegment.values();
            SEGMENT_LENGTH_IN_TICKS = (short)(1200 / VALUES.length);
            for (int i = 0; i < VALUES.length; ++i) {
                DaySegment s = VALUES[i];
                s.segmentIndex = i;
                s.segmentStart = (short)(SEGMENT_LENGTH_IN_TICKS * i);
            }
        }
    }

    static abstract class DynamicImage {
        protected boolean requireSameWorkspaceWidth = false;
        private short requestedTimeOfDay;
        private int requestedWorkspaceWidth;
        private int requestedWorkspaceHeight;
        private SoftReference<BufferedImage> imageRef;

        DynamicImage() {
        }

        BufferedImage get(short timeOfDay, int width, int height) {
            BufferedImage oldResizedGrassImage;
            if (height < 1) {
                this.imageRef = null;
                return null;
            }
            if (!(this.imageRef == null || (oldResizedGrassImage = this.imageRef.get()) == null || this.requireSameWorkspaceWidth && this.requestedWorkspaceWidth != width || this.requestedWorkspaceHeight != height || this.needToRepaint(timeOfDay))) {
                return oldResizedGrassImage;
            }
            BufferedImage image = this.generate(timeOfDay, width, height);
            this.imageRef = new SoftReference<BufferedImage>(image);
            this.requestedTimeOfDay = timeOfDay;
            this.requestedWorkspaceHeight = height;
            return image;
        }

        abstract BufferedImage generate(short var1, int var2, int var3);

        boolean needToRepaint(short newTimeOfDay) {
            DaySegment newDaySegment;
            DaySegment oldDaySegment = DaySegment.get(this.requestedTimeOfDay);
            if (oldDaySegment != (newDaySegment = DaySegment.get(newTimeOfDay))) {
                return true;
            }
            switch (newDaySegment) {
                case NIGHT: 
                case AFTERNOON: {
                    return false;
                }
                case MORNING: 
                case DUSK: {
                    return true;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

