/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.background;

import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.bootstrap.bridge.FlatLafConfiguration;
import ru.turikhay.tlauncher.handlers.ExceptionHandler;
import ru.turikhay.tlauncher.ui.FlatLaf;
import ru.turikhay.tlauncher.ui.background.ISwingBackground;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedComponentAdapter;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.U;

public final class ImageBackground
extends JComponent
implements ISwingBackground {
    private static final Logger LOGGER = LogManager.getLogger(ImageBackground.class);
    private static ImageBackground lastInstance;
    private Image defaultImage;
    private Image currentImage;
    private Image renderImage;
    private boolean paused;

    ImageBackground() {
        lastInstance = this;
        this.addComponentListener(new ExtendedComponentAdapter(this){

            @Override
            public void onComponentResized(ComponentEvent e) {
                ImageBackground.this.updateRender();
            }
        });
    }

    public static ImageBackground getLastInstance() {
        return lastInstance;
    }

    public void wipe() {
        this.currentImage = null;
        this.renderImage = null;
    }

    @Override
    public void onResize() {
        if (this.getParent() != null) {
            this.setSize(this.getParent().getSize());
        }
    }

    @Override
    public void startBackground() {
        this.paused = false;
        this.updateRender();
    }

    @Override
    public void pauseBackground() {
        this.paused = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void loadBackground(String path) throws Exception {
        if (this.defaultImage == null) {
            String defaultImageName = "plains.jpg";
            if (TLauncher.getInstance() != null) {
                Optional<FlatLafConfiguration> flatLafConfiguration = TLauncher.getInstance().getSettings().getFlatLafConfiguration();
                Optional<FlatLafConfiguration.Theme> selectedTheme = FlatLaf.getSelectedNowTheme(flatLafConfiguration);
                if (flatLafConfiguration.isPresent() && selectedTheme.isPresent()) {
                    BufferedImage externalBackgroundImage;
                    defaultImageName = "plains4K.jpg";
                    String selectedThemeFile = (String)flatLafConfiguration.get().getThemeFiles().get(selectedTheme.get());
                    if (selectedThemeFile != null && (externalBackgroundImage = FlatLaf.loadDefaultBackgroundFromThemeFile(selectedThemeFile)) != null) {
                        this.defaultImage = externalBackgroundImage;
                    }
                }
            }
            if (this.defaultImage == null) {
                this.defaultImage = Images.loadImageByName(defaultImageName);
            }
        }
        this.renderImage = null;
        if (path == null) {
            this.currentImage = this.defaultImage;
        } else {
            BufferedImage image;
            InputStream input;
            this.currentImage = null;
            if (U.makeURL(path) == null) {
                File file = new File(path);
                if (!file.isFile()) throw new FileNotFoundException(path);
                input = new FileInputStream(file);
            } else {
                input = U.makeURL(path).openStream();
            }
            if (input == null) {
                throw new IllegalArgumentException("could not parse path: " + path);
            }
            LOGGER.trace("Loading background: {} -> {}", (Object)path, (Object)input);
            try {
                image = ImageIO.read(input);
            }
            catch (Exception e) {
                LOGGER.error("Could not load image: {}", (Object)path, (Object)e);
                Sentry.capture((EventBuilder)new EventBuilder().withMessage("image not found: " + path).withLevel(Event.Level.ERROR).withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)));
                return;
            }
            this.currentImage = image;
        }
        this.updateRender();
    }

    private void updateRender() {
        this.renderImage = null;
        Image image = this.currentImage;
        if (image == null) {
            return;
        }
        this.renderImage = this.renderImage(image);
        this.repaint();
    }

    private Image renderImage(Image image) {
        return this.renderScaleImage(image);
    }

    private Image renderScaleImage(Image image) {
        BufferedImage scaledImage;
        double realWidth = (double)this.getWidth() * SwingUtil.getScalingFactor();
        double realHeight = (double)this.getHeight() * SwingUtil.getScalingFactor();
        try {
            scaledImage = new BufferedImage((int)realWidth, (int)realHeight, 5);
            Graphics2D g = (Graphics2D)scaledImage.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.drawImage(image, 0, 0, scaledImage.getWidth(), scaledImage.getHeight(), null);
        }
        catch (OutOfMemoryError oom) {
            ExceptionHandler.reduceMemory(oom);
            return Images.ONE_PIX.get();
        }
        return scaledImage;
    }

    @Override
    public void paint(Graphics g) {
        Image render;
        Image original = this.currentImage;
        if (original == null || (render = this.renderImage) == null) {
            return;
        }
        double ratio = Math.min((double)original.getWidth(null) / (double)this.getWidth(), (double)original.getHeight(null) / (double)this.getHeight());
        double width = (double)original.getWidth(null) / ratio;
        double height = (double)original.getHeight(null) / ratio;
        double x = ((double)this.getWidth() - width) / 2.0;
        double y = ((double)this.getHeight() - height) / 2.0;
        try {
            g.drawImage(render, (int)x, (int)y, (int)width, (int)height, null);
        }
        catch (OutOfMemoryError oom) {
            ExceptionHandler.reduceMemory(oom);
        }
    }
}

