/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.background;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.ui.background.IFXBackground;
import ru.turikhay.tlauncher.ui.background.ISwingBackground;
import ru.turikhay.tlauncher.ui.swing.ResizeableComponent;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedComponentAdapter;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedLayeredPane;
import ru.turikhay.util.OS;
import ru.turikhay.util.U;
import ru.turikhay.util.async.ExtendedThread;
import ru.turikhay.util.async.FxRunnable;

public class FXWrapper<T extends IFXBackground>
extends ExtendedLayeredPane
implements ISwingBackground {
    private static final Logger LOGGER = LogManager.getLogger(FXWrapper.class);
    private final Class<T> clazz;
    private FXInitializer init;
    private JFX wrapper;

    public FXWrapper(Class<T> fxBackground) {
        this.clazz = fxBackground;
        this.setOpaque(false);
        this.setBackground(java.awt.Color.yellow);
        this.init = new FXInitializer();
        this.addComponentListener(new ExtendedComponentAdapter(this, 200){

            @Override
            public void onComponentResized(ComponentEvent e) {
                if (FXWrapper.this.wrapper != null) {
                    FXWrapper.this.wrapper.onResize();
                }
            }
        });
    }

    private void init(Runnable runnable, boolean join) {
        FXInitializer init = this.init;
        if (init == null) {
            runnable.run();
            return;
        }
        if (init.isAlive()) {
            LOGGER.trace("FX is initializing so far...");
        } else {
            init.start();
        }
        if (join) {
            try {
                init.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            runnable.run();
        } else {
            init.queue.add(runnable);
        }
    }

    private void init(Runnable r) {
        this.init(r, false);
    }

    @Override
    public void onResize() {
        if (this.getParent() != null) {
            Dimension size = this.getParent().getSize();
            this.setSize(size);
        }
    }

    @Override
    public void startBackground() {
        this.init(new FxRunnable(){

            @Override
            public void runFx() {
                FXWrapper.this.wrapper.background.startBackground();
            }
        });
    }

    @Override
    public void pauseBackground() {
        this.init(new FxRunnable(){

            @Override
            public void runFx() {
                FXWrapper.this.wrapper.background.pauseBackground();
            }
        });
    }

    @Override
    public void loadBackground(final String path) {
        this.init(new FxRunnable(){

            @Override
            public void runFx() {
                try {
                    FXWrapper.this.wrapper.background.loadBackground(path);
                }
                catch (Exception e) {
                    LOGGER.error("could not load fx background: {}", (Object)path, (Object)e);
                }
            }
        }, OS.WINDOWS.isCurrent());
    }

    private class FXInitializer
    extends ExtendedThread {
        private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();

        private FXInitializer() {
        }

        @Override
        public void run() {
            Runnable task;
            this.checkCurrent();
            try {
                LOGGER.trace("Initializing...");
                FXWrapper.this.wrapper = new JFX();
            }
            catch (Exception e) {
                LOGGER.error("Could not init FX background", (Throwable)e);
            }
            FXWrapper.this.init = null;
            while ((task = this.queue.poll()) != null) {
                task.run();
            }
        }
    }

    private class JFX
    extends JFXPanel
    implements ResizeableComponent {
        private T background;

        JFX() throws Exception {
            this.setBackground(java.awt.Color.green);
            Exception[] exception = new Exception[1];
            Platform.setImplicitExit((boolean)false);
            Platform.runLater(() -> {
                try {
                    this.background = (IFXBackground)FXWrapper.this.clazz.newInstance();
                    Scene scene = new Scene((Parent)this.background, (Paint)Color.MAGENTA);
                    scene.setFill((Paint)Color.DARKGRAY);
                    this.setScene(scene);
                }
                catch (Exception e) {
                    exception[0] = e;
                    LOGGER.error("Could not create background", (Throwable)exception[0]);
                }
            });
            while (this.background == null && exception[0] == null) {
                U.sleepFor(500L);
            }
            if (exception[0] != null) {
                try {
                    Platform.exit();
                }
                catch (Exception e) {
                    LOGGER.error("Could not exit JavaFX", (Throwable)e);
                }
                throw exception[0];
            }
            FXWrapper.this.add((Component)((Object)this));
            this.onResize();
            LOGGER.debug("FX background successfully created: {}", this.background);
        }

        @Override
        public void onResize() {
            Dimension size = FXWrapper.this.getSize();
            this.setBounds(0, 0, size.width, size.height);
        }
    }
}

