/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.background;

import java.awt.Component;
import javax.swing.JComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.ui.MainPane;
import ru.turikhay.tlauncher.ui.background.Cover;
import ru.turikhay.tlauncher.ui.background.FXWrapper;
import ru.turikhay.tlauncher.ui.background.IBackground;
import ru.turikhay.tlauncher.ui.background.ImageBackground;
import ru.turikhay.tlauncher.ui.background.Worker;
import ru.turikhay.tlauncher.ui.background.fx.MediaFxBackground;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedLayeredPane;
import ru.turikhay.util.JavaVersion;

public final class BackgroundManager
extends ExtendedLayeredPane {
    private static final Logger LOGGER = LogManager.getLogger(BackgroundManager.class);
    private static final int BACKGROUND_INDEX = 1;
    private static final int COVER_INDEX = Integer.MAX_VALUE;
    final Worker worker = new Worker(this);
    final Cover cover = new Cover();
    private final ImageBackground imageBackground;
    private final FXWrapper<MediaFxBackground> mediaFxBackground;
    private IBackground background;

    public BackgroundManager(MainPane pane) {
        super(pane);
        this.add((Component)this.cover, Integer.MAX_VALUE);
        this.imageBackground = new ImageBackground();
        Object oldAnimatedBackground = null;
        FXWrapper<MediaFxBackground> _mediaFxBackground = null;
        try {
            if (JavaVersion.getCurrent().getMajor() >= 11) {
                _mediaFxBackground = new FXWrapper<MediaFxBackground>(MediaFxBackground.class);
            } else {
                LOGGER.info("MediaFxBackground is not be available because it requires Java 11+");
            }
        }
        catch (Throwable t) {
            LOGGER.info("MediaFxBackground will not be available: {}", (Object)t.toString());
            LOGGER.debug("Detailed exception", t);
        }
        this.mediaFxBackground = _mediaFxBackground;
    }

    public ImageBackground getImageBackground() {
        return this.imageBackground;
    }

    public FXWrapper<MediaFxBackground> getMediaFxBackground() {
        return this.mediaFxBackground;
    }

    void setBackground(IBackground background) {
        if (this.background == background) {
            return;
        }
        if (this.background != null) {
            this.background.pauseBackground();
            this.remove((JComponent)((Object)this.background));
        }
        if (background != null) {
            this.add((Component)((JComponent)((Object)background)), 1);
            background.startBackground();
        }
        this.background = background;
        this.onResize();
    }

    public void startBackground() {
        if (this.background != null) {
            this.background.startBackground();
        }
    }

    public void pauseBackground() {
        if (this.background != null) {
            this.background.pauseBackground();
        }
    }

    public void loadBackground() {
        String path = TLauncher.getInstance().getSettings().get("gui.background");
        if (path != null && this.mediaFxBackground != null && (path.endsWith(".mp4") || path.endsWith(".flv"))) {
            this.worker.setBackground(this.mediaFxBackground, path);
        } else {
            this.worker.setBackground(this.imageBackground, path);
        }
    }
}

