/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.account;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.minecraft.auth.Authenticator;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorListener;
import ru.turikhay.tlauncher.minecraft.auth.ExecAuthenticator;
import ru.turikhay.tlauncher.stats.Stats;
import ru.turikhay.tlauncher.ui.account.AccountMultipaneCompCloseable;
import ru.turikhay.tlauncher.ui.account.PaneMode;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.listener.AuthUIListener;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableHTMLLabel;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.loc.LocalizableTextField;
import ru.turikhay.tlauncher.ui.progress.ProgressBar;
import ru.turikhay.tlauncher.ui.scenes.AccountManagerScene;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.ui.text.ExtendedPasswordField;
import ru.turikhay.tlauncher.user.StandardAuth;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.tlauncher.user.UserSet;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;

public abstract class StandardAccountPane<T extends StandardAuth<Y>, Y extends User>
extends ExtendedPanel
implements AccountMultipaneCompCloseable {
    protected final AccountManagerScene scene;
    private final PaneMode mode;
    private final Account.AccountType accountType;
    private final LocalizableTextField emailField;
    private final ExtendedPasswordField passwordField;
    protected final ProgressBar progressBar;
    protected int session = -1;

    public StandardAccountPane(AccountManagerScene scene, PaneMode m, Account.AccountType accountType) {
        this.scene = scene;
        this.mode = Objects.requireNonNull(m, "mode");
        this.accountType = Objects.requireNonNull(accountType, "accountType");
        String LOC_PREFIX = "account.manager.multipane.account-" + accountType.toString().toLowerCase(Locale.ROOT) + ".";
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 21;
        LocalizableLabel emailLabel = new LocalizableLabel(LOC_PREFIX + "email");
        ++c.gridy;
        this.add((Component)emailLabel, c);
        this.emailField = new LocalizableTextField();
        this.emailField.setFont(this.emailField.getFont().deriveFont(this.emailField.getFont().getSize2D() + 2.0f));
        this.emailField.setPlaceholder(LOC_PREFIX + "email.placeholder");
        c.insets = new Insets(SwingUtil.magnify(5), 0, 0, 0);
        ++c.gridy;
        this.add((Component)this.emailField, c);
        LocalizableLabel passwordLabel = new LocalizableLabel(LOC_PREFIX + "password");
        c.insets = new Insets(SwingUtil.magnify(10), 0, 0, 0);
        ++c.gridy;
        this.add((Component)passwordLabel, c);
        this.passwordField = new ExtendedPasswordField();
        this.passwordField.setFont(this.passwordField.getFont().deriveFont(this.passwordField.getFont().getSize2D() + 2.0f));
        c.insets = new Insets(SwingUtil.magnify(5), 0, 0, 0);
        ++c.gridy;
        this.add((Component)this.passwordField, c);
        LocalizableHTMLLabel forgotpasswordLabel = new LocalizableHTMLLabel(LOC_PREFIX + "forgot-password");
        forgotpasswordLabel.setAlignmentX(1.0f);
        forgotpasswordLabel.setHorizontalAlignment(4);
        forgotpasswordLabel.setFont(forgotpasswordLabel.getFont().deriveFont(forgotpasswordLabel.getFont().getSize2D() - 2.0f));
        forgotpasswordLabel.setCursor(Cursor.getPredefinedCursor(12));
        forgotpasswordLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OS.openLink(StandardAccountPane.this.forgotPasswordUrl());
            }
        });
        c.insets = new Insets(SwingUtil.magnify(3), 0, 0, 0);
        ++c.gridy;
        c.anchor = 22;
        this.add((Component)forgotpasswordLabel, c);
        LocalizableButton authButton = new LocalizableButton(LOC_PREFIX + "auth");
        authButton.addActionListener(e -> {
            boolean havePassword;
            String email = this.emailField.getValue();
            char[] password = this.passwordField.getPassword();
            boolean haveEmail = StringUtils.isNotBlank((CharSequence)email);
            boolean bl = havePassword = password != null && password.length > 0;
            if (!haveEmail || !havePassword) {
                Alert.showLocError("account.manager.multipane.add-account.error.no-credentials");
                return;
            }
            switch (this.mode) {
                case ADD: {
                    this.removeAccountIfFound(email);
                    break;
                }
                case EDIT: {
                    String oldUsername;
                    String string = oldUsername = scene.list.getSelected() == null || scene.list.getSelected().getType() != accountType ? null : scene.list.getSelected().getUsername();
                    if (oldUsername == null) break;
                    this.removeAccountIfFound(oldUsername);
                }
            }
            int currentSession = this.session = Math.abs(new Random().nextInt());
            this.credentialsEntered(currentSession, email, new String(password));
        });
        authButton.setFont(authButton.getFont().deriveFont(1));
        authButton.setIcon(Images.getIcon24(this.accountIcon()));
        c.insets = new Insets(SwingUtil.magnify(15), 0, 0, 0);
        ++c.gridy;
        c.anchor = 21;
        this.add((Component)authButton, c);
        this.progressBar = new ProgressBar();
        c.insets = new Insets(SwingUtil.magnify(2), 0, 0, 0);
        ++c.gridy;
        this.add((Component)this.progressBar, c);
        if (this.mode == PaneMode.EDIT) {
            LocalizableButton removeButton = new LocalizableButton("account.manager.multipane.remove-account");
            removeButton.setIcon(Images.getIcon16("remove"));
            removeButton.addActionListener(e -> {
                Account<? extends User> selected = scene.list.getSelected();
                if (selected != null && selected.getType() == accountType) {
                    TLauncher.getInstance().getProfileManager().getAccountManager().getUserSet().remove(selected.getUser());
                }
                scene.multipane.goBack();
            });
            c.insets = new Insets(SwingUtil.magnify(12), 0, 0, 0);
            ++c.gridy;
            c.anchor = 21;
            this.add((Component)removeButton, c);
        }
        this.passwordField.addActionListener(e -> authButton.doClick());
    }

    static void removeAccountIfFound(String username, Account.AccountType type) {
        UserSet userSet = TLauncher.getInstance().getProfileManager().getAccountManager().getUserSet();
        User user = userSet.getByUsername(username, type.name().toLowerCase(Locale.ROOT));
        if (user != null) {
            userSet.remove(user);
        }
    }

    protected void removeAccountIfFound(String username) {
        StandardAccountPane.removeAccountIfFound(username, this.accountType);
    }

    protected final void credentialsEntered(final int currentSession, String email, String password) {
        final ExecAuthenticator authenticator = Authenticator.instanceFor(() -> {
            T auth = this.standardAuth();
            Object user = auth.authorize(email, password);
            return new Account(user);
        }, this.accountType);
        AuthUIListener l = new AuthUIListener(new AuthenticatorListener<Y>(){

            @Override
            public void onAuthPassing(Authenticator<? extends Y> var1) {
                if (StandardAccountPane.this.session == currentSession) {
                    Blocker.blockComponents(StandardAccountPane.this, "user-pass");
                    StandardAccountPane.this.progressBar.setIndeterminate(true);
                }
            }

            @Override
            public void onAuthPassingError(Authenticator<? extends Y> var1, Throwable var2) {
                if (StandardAccountPane.this.session == currentSession) {
                    Stats.accountCreation(StandardAccountPane.this.accountType.toString().toLowerCase(Locale.ROOT), "standard", "", false);
                    Blocker.unblockComponents(StandardAccountPane.this, "user-pass");
                    StandardAccountPane.this.progressBar.setIndeterminate(false);
                }
            }

            @Override
            public void onAuthPassed(Authenticator<? extends Y> var1) {
                if (StandardAccountPane.this.session == currentSession) {
                    Blocker.unblockComponents(StandardAccountPane.this, "user-pass");
                    StandardAccountPane.this.progressBar.setIndeterminate(false);
                    Account account = authenticator.getAccount();
                    switch (StandardAccountPane.this.mode) {
                        case ADD: {
                            StandardAccountPane.this.removeAccountIfFound(account.getUsername());
                            Stats.accountCreation(StandardAccountPane.this.accountType.toString().toLowerCase(Locale.ROOT), "standard", "", true);
                            break;
                        }
                        case EDIT: {
                            Object newUser = account.getUser();
                            TLauncher.getInstance().getProfileManager().getAccountManager().getUserSet().remove(newUser);
                        }
                    }
                    TLauncher.getInstance().getProfileManager().getAccountManager().getUserSet().add(account.getUser());
                    StandardAccountPane.this.scene.list.select(account);
                    StandardAccountPane.this.scene.multipane.showTip("success-" + StandardAccountPane.this.mode.toString().toLowerCase(Locale.ROOT));
                }
            }
        });
        l.editorOpened = true;
        authenticator.asyncPass(l);
    }

    protected abstract String accountIcon();

    protected abstract String forgotPasswordUrl();

    protected abstract T standardAuth();

    @Override
    public void multipaneClosed() {
        this.session = -1;
    }

    @Override
    public Component multipaneComp() {
        return this;
    }

    @Override
    public String multipaneName() {
        return this.mode.toString().toLowerCase(Locale.ROOT) + "-account-" + this.accountType.toString().toLowerCase(Locale.ROOT);
    }

    @Override
    public boolean multipaneLocksView() {
        return true;
    }

    @Override
    public void multipaneShown(boolean gotBack) {
        this.emailField.setValue((Object)null);
        this.passwordField.setText(null);
        if (this.mode == PaneMode.EDIT && this.scene.list.getSelected() != null && this.scene.list.getSelected().getType() == this.accountType) {
            Account<? extends User> account = this.scene.list.getSelected();
            this.emailField.setValue((Object)account.getUsername());
        }
    }
}

