/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.account;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.ui.account.AccountMultipaneCompCloseable;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.loc.LocalizableTextField;
import ru.turikhay.tlauncher.ui.scenes.AccountManagerScene;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.util.SwingUtil;

public class NoAccountEdit
extends ExtendedPanel
implements AccountMultipaneCompCloseable {
    private final AccountManagerScene scene;
    private final Account.AccountType type;
    private final LocalizableTextField field;

    public NoAccountEdit(AccountManagerScene scene, Account.AccountType type) {
        this.scene = scene;
        this.type = type;
        String LOC_PREFIX = "account.manager.multipane.account-" + (Object)((Object)type) + ".";
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 21;
        LocalizableLabel label = new LocalizableLabel(LOC_PREFIX + "label");
        label.setIcon(Images.getIcon24(type.getIcon()));
        ++c.gridy;
        this.add((Component)label, c);
        this.field = new LocalizableTextField();
        this.field.setEditable(false);
        this.field.setFont(this.field.getFont().deriveFont(this.field.getFont().getSize2D() + 4.0f));
        c.insets = new Insets(SwingUtil.magnify(5), 0, 0, 0);
        ++c.gridy;
        this.add((Component)this.field, c);
        LocalizableButton removeButton = new LocalizableButton("account.manager.multipane.remove-account");
        removeButton.setIcon(Images.getIcon16("remove"));
        removeButton.addActionListener(e -> {
            Account<? extends User> selected = scene.list.getSelected();
            if (selected != null && selected.getType() == type) {
                TLauncher.getInstance().getProfileManager().getAccountManager().getUserSet().remove(selected.getUser());
            }
            scene.multipane.goBack();
        });
        c.insets = new Insets(SwingUtil.magnify(12), 0, 0, 0);
        ++c.gridy;
        c.anchor = 21;
        this.add((Component)removeButton, c);
    }

    @Override
    public void multipaneClosed() {
    }

    @Override
    public Component multipaneComp() {
        return this;
    }

    @Override
    public String multipaneName() {
        return "edit-account-" + (Object)((Object)this.type);
    }

    @Override
    public boolean multipaneLocksView() {
        return true;
    }

    @Override
    public void multipaneShown(boolean gotBack) {
        this.field.setValue((Object)null);
        Account<? extends User> selected = this.scene.list.getSelected();
        if (selected != null && selected.getType().equals((Object)this.type)) {
            this.field.setValue((Object)selected.getUsername());
        }
    }
}

