/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.account;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.managers.AccountManager;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.ui.account.AccountMultipaneCompCloseable;
import ru.turikhay.tlauncher.ui.account.PaneMode;
import ru.turikhay.tlauncher.ui.account.StandardAccountPane;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.loc.LocalizableTextField;
import ru.turikhay.tlauncher.ui.scenes.AccountManagerScene;
import ru.turikhay.tlauncher.ui.swing.DocumentChangeListener;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.ui.theme.Theme;
import ru.turikhay.tlauncher.user.PlainUser;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.util.SwingUtil;

public class AccountPlainPane
extends ExtendedPanel
implements AccountMultipaneCompCloseable {
    private static final String[] DISALLOWED = new String[]{"turikhay", "nik_mmzd", "mcmodder", "DarikXPlay", "ErickSkrauch"};
    private final AccountManagerScene scene;
    private final LocalizableTextField field;
    private final PaneMode mode;
    private boolean unlocked;

    public AccountPlainPane(AccountManagerScene scene, PaneMode mode) {
        this.scene = scene;
        this.mode = mode;
        String LOC_PREFIX = "account.manager.multipane.account-plain.";
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 21;
        LocalizableLabel label = new LocalizableLabel(LOC_PREFIX + "label");
        ++c.gridy;
        this.add((Component)label, c);
        this.field = new LocalizableTextField();
        this.field.getDocument().addDocumentListener(new DocumentChangeListener(){
            private boolean wasValid = true;

            @Override
            public void documentChanged(DocumentEvent e) {
                String v = AccountPlainPane.this.field.getValue();
                this.setValid(StringUtils.isEmpty((CharSequence)v) || AccountPlainPane.isNameValid(v));
            }

            private void setValid(boolean valid) {
                if (this.wasValid == valid) {
                    return;
                }
                if (valid) {
                    AccountPlainPane.this.field.setBackground(UIManager.getColor("TextField.background"));
                } else {
                    AccountPlainPane.this.field.setBackground(Theme.getTheme().getFailure());
                }
                this.wasValid = valid;
            }
        });
        this.field.setFont(this.field.getFont().deriveFont(this.field.getFont().getSize2D() + 4.0f));
        this.field.setPlaceholder(LOC_PREFIX + "placeholder");
        c.insets = new Insets(SwingUtil.magnify(5), 0, 0, 0);
        ++c.gridy;
        this.add((Component)this.field, c);
        LocalizableButton button = new LocalizableButton(LOC_PREFIX + (mode == PaneMode.EDIT ? "edit" : "save"));
        button.addActionListener(e -> {
            String username = this.field.getValue();
            if ("\u0440\u0430\u0437\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c".equalsIgnoreCase(username)) {
                this.field.setValue((Object)null);
                this.unlocked = true;
                return;
            }
            if (StringUtils.isBlank((CharSequence)username)) {
                Alert.showLocError("account.manager.multipane.add-account.error.no-credentials");
                return;
            }
            if (!AccountPlainPane.isNameValid(username)) {
                Alert.showLocError("account.manager.multipane.account-plain.invalid");
                return;
            }
            String checkUsername = null;
            switch (mode) {
                case ADD: {
                    checkUsername = username;
                    break;
                }
                case EDIT: {
                    String[] oldUsername;
                    Object object = oldUsername = scene.list.getSelected() != null && scene.list.getSelected().getType() == Account.AccountType.PLAIN ? scene.list.getSelected().getUsername() : null;
                    if (username.equalsIgnoreCase((String)oldUsername)) break;
                    checkUsername = username;
                }
            }
            if (mode == PaneMode.EDIT && scene.list.getSelected() != null) {
                TLauncher.getInstance().getProfileManager().getAccountManager().getUserSet().remove(scene.list.getSelected().getUser());
            }
            if (checkUsername != null) {
                StandardAccountPane.removeAccountIfFound(checkUsername, Account.AccountType.PLAIN);
            }
            if (!this.unlocked) {
                for (String disallowed : DISALLOWED) {
                    if (!disallowed.equalsIgnoreCase(username)) continue;
                    return;
                }
            }
            PlainUser user = AccountManager.getPlainAuth().authorize(username);
            TLauncher.getInstance().getProfileManager().getAccountManager().getUserSet().add(user);
            this.scene.list.select(new Account<PlainUser>(user));
            this.scene.multipane.showTip("success-" + mode.toString().toLowerCase(Locale.ROOT));
        });
        button.setFont(button.getFont().deriveFont(1));
        button.setIcon(Images.getIcon24("user-circle-o"));
        ++c.gridy;
        this.add((Component)button, c);
        if (mode == PaneMode.EDIT) {
            LocalizableButton removeButton = new LocalizableButton("account.manager.multipane.remove-account");
            removeButton.setIcon(Images.getIcon16("remove"));
            removeButton.addActionListener(e -> {
                Account<? extends User> selected = scene.list.getSelected();
                if (selected != null && selected.getType() == Account.AccountType.PLAIN) {
                    TLauncher.getInstance().getProfileManager().getAccountManager().getUserSet().remove(selected.getUser());
                }
                scene.multipane.goBack();
            });
            c.insets = new Insets(SwingUtil.magnify(12), 0, 0, 0);
            ++c.gridy;
            c.anchor = 21;
            this.add((Component)removeButton, c);
        }
        this.field.addActionListener(e -> {
            button.doClick();
            if (this.unlocked) {
                this.field.grabFocus();
            }
        });
    }

    @Override
    public void multipaneClosed() {
    }

    @Override
    public Component multipaneComp() {
        return this;
    }

    @Override
    public String multipaneName() {
        return this.mode.toString().toLowerCase(Locale.ROOT) + "-account-plain";
    }

    @Override
    public boolean multipaneLocksView() {
        return true;
    }

    @Override
    public void multipaneShown(boolean gotBack) {
        Account<? extends User> selected;
        this.field.setValue((Object)null);
        if (this.mode == PaneMode.EDIT && (selected = this.scene.list.getSelected()) != null && selected.getType() == Account.AccountType.PLAIN) {
            this.field.setValue((Object)selected.getUsername());
        }
    }

    private static boolean isNameValid(String name) {
        return name != null && name.length() <= 16 && name.chars().noneMatch(ch -> ch <= 32 || ch >= 127);
    }
}

