/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.account;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import ru.turikhay.tlauncher.ui.account.AccountMultipaneComp;
import ru.turikhay.tlauncher.ui.account.AccountMultipaneCompCloseable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.center.CenterPanel;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.scenes.AccountManagerScene;
import ru.turikhay.tlauncher.ui.swing.Multipane;
import ru.turikhay.tlauncher.ui.swing.ScrollPane;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedButton;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.U;

public class AccountMultipane
extends CenterPanel
implements LocalizableComponent {
    private final AccountManagerScene scene;
    private final ExtendedButton back;
    private final LocalizableLabel title;
    private final Multipane multipane;
    private final Map<String, AccountMultipaneComp> byName = new HashMap<String, AccountMultipaneComp>();
    private AccountMultipaneComp currentComp;
    private final ArrayList<AccountMultipaneComp> breadcrumbs = new ArrayList();

    public AccountMultipane(AccountManagerScene scene) {
        super(squareInsets);
        this.scene = scene;
        BorderPanel wrapper = new BorderPanel(0, SwingUtil.magnify(10));
        wrapper.setInsets(0, 0, 0, 0);
        BorderPanel titlePanel = new BorderPanel();
        titlePanel.setHgap(SwingUtil.magnify(10));
        this.back = new ExtendedButton();
        this.updateBackButtonTooltip();
        this.back.addActionListener(e -> this.goBack());
        this.back.setIcon(Images.getIcon16("arrow-left"));
        titlePanel.setWest(this.back);
        this.title = new LocalizableLabel();
        this.title.setFont(this.title.getFont().deriveFont(this.title.getFont().getSize2D() + 8.0f).deriveFont(1));
        this.title.setForeground(U.shiftAlpha(this.title.getForeground(), -96));
        this.title.setNotEmpty(true);
        titlePanel.setCenter(this.title);
        wrapper.setNorth(titlePanel);
        this.multipane = new Multipane();
        wrapper.setCenter(this.multipane);
        this.add((Component)wrapper);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int width = AccountMultipane.this.getWidth() - AccountMultipane.this.getInsets().left - AccountMultipane.this.getInsets().right - SwingUtil.magnify(30);
                AccountMultipane.this.multipane.setPreferredSize(new Dimension(width, AccountMultipane.this.getHeight() - AccountMultipane.this.getInsets().top - AccountMultipane.this.getInsets().bottom - AccountMultipane.this.back.getHeight() - SwingUtil.magnify(40)));
                AccountMultipane.this.byName.values().forEach(c -> c.multipaneComp().setMaximumSize(new Dimension(width, Integer.MAX_VALUE)));
            }
        });
    }

    public String currentTip() {
        return this.currentComp == null ? null : this.currentComp.multipaneName();
    }

    public void goBack() {
        if (this.breadcrumbs.size() < 2) {
            this.showTip("welcome");
        } else {
            this.showTip(this.breadcrumbs.get(this.breadcrumbs.size() - 2), true);
        }
    }

    public void clearBreadcrumbs() {
        this.breadcrumbs.clear();
    }

    public void registerTip(AccountMultipaneComp comp) {
        this.byName.put(comp.multipaneName(), comp);
        ScrollPane scrollPane = new ScrollPane(comp.multipaneComp(), ScrollPane.ScrollBarPolicy.AS_NEEDED, ScrollPane.ScrollBarPolicy.NEVER);
        this.multipane.add((Component)scrollPane, comp.multipaneName());
    }

    public void showTip(String name) {
        AccountMultipaneComp comp = this.byName.get(name);
        if (comp == null) {
            throw new IllegalArgumentException("no tip found: " + name);
        }
        this.showTip(comp, false);
    }

    private void showTip(AccountMultipaneComp comp, boolean gotBack) {
        if (this.currentComp != null && this.currentComp instanceof AccountMultipaneCompCloseable) {
            ((AccountMultipaneCompCloseable)this.currentComp).multipaneClosed();
        }
        if (!(comp instanceof AccountMultipaneCompCloseable)) {
            this.breadcrumbs.clear();
        } else if (!gotBack) {
            this.breadcrumbs.add(comp);
        } else {
            this.breadcrumbs.remove(this.breadcrumbs.size() - 1);
        }
        this.currentComp = comp;
        if (comp.multipaneLocksView()) {
            Blocker.block(this.scene, "tip-lock");
        } else {
            Blocker.unblock(this.scene, "tip-lock");
        }
        this.title.setText("account.manager.multipane." + comp.multipaneName() + ".title");
        this.multipane.show(comp.multipaneName());
        this.back.setVisible(comp instanceof AccountMultipaneCompCloseable);
        this.repaint();
        comp.multipaneShown(gotBack);
    }

    @Override
    public void updateLocale() {
        this.updateBackButtonTooltip();
        Localizable.updateContainer(this.title);
        Localizable.updateContainer(this.multipane);
    }

    private void updateBackButtonTooltip() {
        this.back.setToolTipText(Localizable.get("account.manager.multipane.back"));
    }
}

