/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.account;

import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.ui.account.AccountMinecraftProcess;
import ru.turikhay.tlauncher.ui.account.StandardAccountPane;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.user.MinecraftUser;
import ru.turikhay.tlauncher.user.UserSet;
import ru.turikhay.tlauncher.user.minecraft.oauth.OAuthApplication;
import ru.turikhay.tlauncher.user.minecraft.strategy.MinecraftAuthenticationException;
import ru.turikhay.tlauncher.user.minecraft.strategy.gos.GameOwnershipValidationException;
import ru.turikhay.tlauncher.user.minecraft.strategy.gos.GameOwnershipValidator;
import ru.turikhay.tlauncher.user.minecraft.strategy.mcsauth.MinecraftServicesAuthenticator;
import ru.turikhay.tlauncher.user.minecraft.strategy.mcsauth.MinecraftServicesToken;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.CodeRequestCancelledException;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.MicrosoftOAuthCodeRequestStrategy;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.MicrosoftOAuthExchangeCode;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.OAuthUrlParser;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.DefaultExternalBrowser;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.LocalServerConfiguration;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.LocalServerSelectedConfiguration;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.LocalServerStrategy;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.LocalServerUrlProducer;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.nanohttpd.NanoHttpdLocalServer;
import ru.turikhay.tlauncher.user.minecraft.strategy.oatoken.MicrosoftOAuthToken;
import ru.turikhay.tlauncher.user.minecraft.strategy.oatoken.exchange.MicrosoftOAuthCodeExchanger;
import ru.turikhay.tlauncher.user.minecraft.strategy.pconv.MinecraftProfileConverter;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.MinecraftOAuthProfile;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.MinecraftProfileRequester;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.ProfileNotCreatedException;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.create.MinecraftProfileCreator;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.create.ProfileCreationAbortedException;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.create.ProfileCreatorUserInterface;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.XboxServiceAuthenticationResponse;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.auth.XboxLiveAuthenticator;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.xsts.XSTSAuthenticator;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.async.AsyncThread;

class AccountMinecraftProcessWorker {
    private static final Logger LOGGER = LogManager.getLogger(AccountMinecraftProcessWorker.class);
    private final AccountMinecraftProcess parent;
    private final String locPrefix;
    private Future<?> currentProcess;
    private final LocalServerUrlProducer urlProducer = new LocalServerUrlProducer();

    AccountMinecraftProcessWorker(AccountMinecraftProcess parent) {
        this.parent = parent;
        this.locPrefix = parent.LOC_PREFIX;
    }

    private void run() {
        try {
            this.doRun();
        }
        catch (InterruptedException | TimeoutException e) {
            this.setState("cancelled");
            this.stopProgress();
        }
        catch (MinecraftAuthenticationException e) {
            this.stopProgress();
            if (e instanceof GameOwnershipValidationException && ((GameOwnershipValidationException)e).isKnownNotToOwn()) {
                LOGGER.info("User does not own Minecraft or not yet migrated their Mojang account");
                this.setState("dont-own");
                Alert.showLocError(this.locPrefix + "dont-own.alert.title", this.locPrefix + "dont-own.alert.message", null);
            } else if (e instanceof CodeRequestCancelledException) {
                this.setState("cancelled");
                LOGGER.info("User cancelled OAuth code request: {}", (Object)e.toString());
            } else {
                LOGGER.warn("Authentication failed", (Throwable)e);
                this.showError(e);
            }
        }
        catch (Exception e) {
            LOGGER.error("Something went wrong while authenticating", (Throwable)e);
            this.showError(e);
        }
    }

    private void showError(Exception e) {
        this.setState("error");
        this.stopProgress();
        Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.ERROR).withMessage("microsoft auth failed").withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)));
        if (e instanceof MinecraftAuthenticationException) {
            String key = ((MinecraftAuthenticationException)e).getShortKey();
            Alert.showLocError("account.manager.error.title", "account.manager.error.minecraft." + key, e.toString());
        } else {
            Alert.showLocError(this.locPrefix + "error.title", this.locPrefix + "error.message", e.toString());
        }
    }

    private void stopProgress() {
        SwingUtil.later(this.parent::stopProgress);
    }

    private void doRun() throws Exception {
        MinecraftOAuthProfile minecraftProfile;
        OAuthApplication application = OAuthApplication.TL;
        this.setState("browser-open");
        MicrosoftOAuthCodeRequestStrategy requestStrategy = this.initBrowser();
        if (requestStrategy instanceof LocalServerStrategy) {
            LocalServerSelectedConfiguration selectedConfig = ((LocalServerStrategy)requestStrategy).startServer();
            String loginUrl = this.urlProducer.buildLoginUrl(selectedConfig);
            SwingUtil.later(() -> this.parent.setButtonLink(loginUrl));
        }
        MicrosoftOAuthExchangeCode msftExhangeCode = requestStrategy.requestMicrosoftOAuthCode();
        SwingUtil.later(() -> this.parent.setButtonLink(null));
        this.setState("exchanging-code");
        MicrosoftOAuthToken msftToken = new MicrosoftOAuthCodeExchanger(application).exchangeMicrosoftOAuthCode(msftExhangeCode);
        this.setState("xbox-live-auth");
        XboxServiceAuthenticationResponse xboxLiveToken = new XboxLiveAuthenticator(application).xboxLiveAuthenticate(msftToken.getAccessToken());
        XboxServiceAuthenticationResponse xstsToken = new XSTSAuthenticator().xstsAuthenticate(xboxLiveToken.getToken());
        this.setState("mcs-auth");
        MinecraftServicesToken minecraftToken = new MinecraftServicesAuthenticator().minecraftServicesAuthenticate(xstsToken);
        this.setState("game-ownership");
        new GameOwnershipValidator().checkGameOwnership(minecraftToken);
        this.setState("getting-profile");
        try {
            minecraftProfile = new MinecraftProfileRequester().requestProfile(minecraftToken);
        }
        catch (ProfileNotCreatedException e) {
            LOGGER.info("User starts Minecraft for the first time");
            minecraftProfile = this.handleProfileCreation(minecraftToken);
        }
        MinecraftUser minecraftUser = new MinecraftProfileConverter().convertToMinecraftUser(msftToken, minecraftToken, minecraftProfile);
        SwingUtil.wait(() -> {
            StandardAccountPane.removeAccountIfFound(minecraftUser.getUsername(), Account.AccountType.MINECRAFT);
            UserSet userSet = TLauncher.getInstance().getProfileManager().getAccountManager().getUserSet();
            userSet.add(minecraftUser);
            userSet.getSet().stream().filter(u -> u.getType().equals("mojang") && u.getUUID().equals(minecraftUser.getUUID())).findAny().ifPresent(userSet::remove);
            this.parent.scene.multipane.showTip("success-add");
            this.parent.scene.list.select(new Account<MinecraftUser>(minecraftUser));
        });
    }

    private MicrosoftOAuthCodeRequestStrategy initBrowser() {
        return new LocalServerStrategy(new DefaultExternalBrowser(), this.urlProducer, new NanoHttpdLocalServer(new OAuthUrlParser(), this.urlProducer), new LocalServerConfiguration("localhost", Arrays.asList(46521, 47522, 48523, 49524), "", "https://llaun.ch/msft-auth-success"));
    }

    private MinecraftOAuthProfile handleProfileCreation(MinecraftServicesToken token) throws IOException, ProfileCreationAbortedException {
        return new MinecraftProfileCreator(new ProfileCreatorUserInterface(){
            final String prefix;
            boolean showHead;
            {
                this.prefix = AccountMinecraftProcessWorker.this.locPrefix + "profile-create.";
                this.showHead = true;
            }

            @Override
            public String requestProfileName() {
                boolean showHead = this.showHead;
                this.showHead = false;
                return Alert.showInputQuestion("", (showHead ? Localizable.get(this.prefix + "question.head") + "\n\n" : "") + Localizable.get(this.prefix + "question.body"));
            }

            @Override
            public void showProfileUnavailableMessage(String profileName) {
                LOGGER.info("Profile is not available: {}", (Object)profileName);
                Alert.showError("", Localizable.get(this.prefix + "unavailable"));
            }
        }).createProfile(token);
    }

    private void setState(String label) {
        SwingUtil.later(() -> this.parent.setProcessLabel(label));
    }

    void start() {
        this.cancel();
        this.currentProcess = AsyncThread.future(this::run);
    }

    void cancel() {
        if (this.currentProcess != null) {
            this.currentProcess.cancel(true);
            this.currentProcess = null;
        }
    }
}

