/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.account;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.ui.account.AccountMinecraftProcessWorker;
import ru.turikhay.tlauncher.ui.account.AccountMultipaneCompCloseable;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.progress.ProgressBar;
import ru.turikhay.tlauncher.ui.scenes.AccountManagerScene;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.util.SwingUtil;

public class AccountMinecraftProcess
extends BorderPanel
implements AccountMultipaneCompCloseable {
    private static final Logger LOGGER = LogManager.getLogger(AccountMinecraftProcess.class);
    final String LOC_PREFIX = "account.manager.multipane." + this.multipaneName() + ".";
    final AccountManagerScene scene;
    private final AccountMinecraftProcessWorker worker;
    private final ProgressBar progressBar;
    private final LocalizableLabel label;
    private final LocalizableButton button;
    private String buttonLink;

    public AccountMinecraftProcess(AccountManagerScene scene) {
        this.scene = scene;
        this.worker = new AccountMinecraftProcessWorker(this);
        ExtendedPanel panel = new ExtendedPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 2;
        c.gridy = -1;
        this.progressBar = new ProgressBar();
        this.progressBar.setPreferredSize(SwingUtil.magnify(new Dimension(1, 24)));
        ++c.gridy;
        panel.add((Component)this.progressBar, c);
        this.label = new LocalizableLabel(this.LOC_PREFIX + "waiting");
        ++c.gridy;
        panel.add((Component)this.label, c);
        this.setCenter(panel);
        this.button = new LocalizableButton(this.LOC_PREFIX + "link.open");
        this.button.addActionListener(e -> {
            if (this.buttonLink != null) {
                Alert.showLocMessage(this.LOC_PREFIX + "link.open.alert", this.buttonLink);
            }
        });
        this.button.setIconTextGap(SwingUtil.magnify(10));
        this.button.setIcon(Images.getIcon24("share"));
        this.setSouth(this.button);
    }

    void setProcessLabel(String label) {
        this.label.setText(this.LOC_PREFIX + label);
    }

    void setButtonLink(String link) {
        this.buttonLink = link;
        this.button.setVisible(link != null);
    }

    void stopProgress() {
        this.progressBar.setIndeterminate(false);
        this.button.setVisible(false);
    }

    @Override
    public void multipaneShown(boolean gotBack) {
        this.setProcessLabel("starting");
        this.progressBar.setIndeterminate(true);
        this.worker.start();
    }

    @Override
    public void multipaneClosed() {
        this.progressBar.setIndeterminate(false);
        this.worker.cancel();
    }

    @Override
    public Component multipaneComp() {
        return this;
    }

    @Override
    public String multipaneName() {
        return "process-account-minecraft";
    }

    @Override
    public boolean multipaneLocksView() {
        return true;
    }
}

