/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.account;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Locale;
import java.util.Objects;
import ru.turikhay.tlauncher.managers.McleaksManager;
import ru.turikhay.tlauncher.managers.McleaksStatus;
import ru.turikhay.tlauncher.managers.McleaksStatusListener;
import ru.turikhay.tlauncher.ui.account.AccountMultipaneCompCloseable;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.progress.ProgressBar;
import ru.turikhay.tlauncher.ui.scenes.AccountManagerScene;
import ru.turikhay.tlauncher.ui.swing.editor.EditorPane;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.ui.swing.extended.HtmlSubstitutor;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.git.TokenReplacingReader;

public class AccountMcleaksStart
extends BorderPanel
implements AccountMultipaneCompCloseable,
LocalizableComponent,
McleaksStatusListener,
Blockable {
    private final String LOC_PREFIX = "account.manager.multipane." + this.multipaneName() + ".";
    private final LocalizableButton button;
    private final Blockable buttonBlocker = new Blockable(){

        @Override
        public void block(Object var1) {
            AccountMcleaksStart.this.button.setEnabled(false);
        }

        @Override
        public void unblock(Object var1) {
            AccountMcleaksStart.this.button.setEnabled(true);
        }
    };
    private final EditorPane content = new EditorPane();
    private final ProgressBar progressBar;
    private StartState state;
    private boolean managerUpdated;
    private boolean mcleaksUpdated;
    private boolean mcleaksAvailable;

    public AccountMcleaksStart(AccountManagerScene scene) {
        this.setCenter(this.content);
        ExtendedPanel panel = new ExtendedPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 2;
        c.gridy = -1;
        this.button = new LocalizableButton();
        this.button.addActionListener(e -> {
            switch (this.state) {
                case DESCRIPTION: {
                    this.setState(StartState.WAITING);
                    break;
                }
                case GET_ALT_TOKEN: 
                case WAITING: {
                    scene.multipane.showTip("process-account-mcleaks");
                }
            }
        });
        this.button.setIcon(Images.getIcon24("logo-mcleaks"));
        this.button.setFont(this.button.getFont().deriveFont(1));
        ++c.gridy;
        panel.add((Component)this.button, c);
        this.progressBar = new ProgressBar();
        this.progressBar.setPreferredSize(new Dimension(1, SwingUtil.magnify(10)));
        ++c.gridy;
        panel.add((Component)this.progressBar, c);
        this.setSouth(panel);
        if (McleaksManager.isUnsupported()) {
            this.setState(StartState.UNSUPPORTED);
        } else {
            this.setState(StartState.DESCRIPTION);
            McleaksManager.getStatus().addListener(this);
        }
    }

    private void setState(StartState state) {
        if (McleaksManager.isUnsupported() || this.mcleaksUpdated && !this.mcleaksAvailable) {
            state = StartState.UNSUPPORTED;
        } else if (state == StartState.WAITING && this.mcleaksUpdated) {
            state = StartState.GET_ALT_TOKEN;
        }
        this.state = Objects.requireNonNull(state, "state");
        this.button.setText(this.LOC_PREFIX + state.toString().toLowerCase(Locale.ROOT) + ".button");
        Blocker.setBlocked("state-required", state.blockButton, this.buttonBlocker);
        this.content.setText(TokenReplacingReader.resolveVars(Localizable.get(this.LOC_PREFIX + (state == StartState.UNSUPPORTED ? StartState.DESCRIPTION : state).toString().toLowerCase(Locale.ROOT) + ".body"), new HtmlSubstitutor()));
    }

    @Override
    public void setMaximumSize(Dimension maximumSize) {
        super.setMaximumSize(maximumSize);
        this.content.setPreferredSize(new Dimension(0, 0));
    }

    @Override
    public void multipaneClosed() {
    }

    @Override
    public Component multipaneComp() {
        return this;
    }

    @Override
    public String multipaneName() {
        return "add-account-mcleaks";
    }

    @Override
    public boolean multipaneLocksView() {
        return true;
    }

    @Override
    public void multipaneShown(boolean gotBack) {
        if (!McleaksManager.isUnsupported()) {
            McleaksManager.triggerConnection();
        }
        this.setState(StartState.DESCRIPTION);
    }

    @Override
    public void updateLocale() {
        this.setState(this.state);
    }

    @Override
    public void onMcleaksUpdating(McleaksStatus status) {
        this.mcleaksUpdated = false;
        this.progressBar.setIndeterminate(true);
        this.progressBar.setValue(0);
    }

    @Override
    public void onMcleaksUpdated(McleaksStatus status) {
        this.mcleaksUpdated = true;
        this.mcleaksAvailable = status.getServerIp() != null;
        this.progressBar.setIndeterminate(false);
        if (this.mcleaksAvailable) {
            this.progressBar.setValue(100);
        } else {
            this.progressBar.setValue(0);
        }
        if (this.state == StartState.WAITING) {
            this.setState(StartState.GET_ALT_TOKEN);
        }
    }

    @Override
    public void block(Object var1) {
        Blocker.block(this.buttonBlocker, var1);
        Blocker.blockComponents(var1, this.content, this.progressBar);
    }

    @Override
    public void unblock(Object var1) {
        Blocker.unblock(this.buttonBlocker, var1);
        Blocker.unblockComponents(var1, this.content, this.progressBar);
    }

    private static enum StartState {
        UNSUPPORTED(true),
        DESCRIPTION,
        GET_ALT_TOKEN,
        WAITING(true);

        private final boolean blockButton;

        private StartState(boolean blockButton) {
            this.blockButton = blockButton;
        }

        private StartState() {
            this(false);
        }
    }
}

