/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.account;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.managers.AccountManager;
import ru.turikhay.tlauncher.managers.McleaksManager;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.minecraft.auth.Authenticator;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorListener;
import ru.turikhay.tlauncher.stats.Stats;
import ru.turikhay.tlauncher.ui.account.AccountMultipaneCompCloseable;
import ru.turikhay.tlauncher.ui.account.PaneMode;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.listener.AuthUIListener;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.loc.LocalizableTextField;
import ru.turikhay.tlauncher.ui.progress.ProgressBar;
import ru.turikhay.tlauncher.ui.scenes.AccountManagerScene;
import ru.turikhay.tlauncher.ui.swing.TextPopup;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.user.McleaksUser;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;

public class AccountMcleaksPane
extends BorderPanel
implements AccountMultipaneCompCloseable,
Blockable {
    private final String LOC_PREFIX;
    private final PaneMode mode;
    private final AccountManagerScene scene;
    private final LocalizableTextField username;
    private final LocalizableTextField oldToken;
    private final LocalizableTextField newToken;
    private final LocalizableButton button;
    private final ProgressBar progressBar;
    private final Blockable buttonBlocker = new Blockable(){

        @Override
        public void block(Object var1) {
            AccountMcleaksPane.this.button.setEnabled(false);
        }

        @Override
        public void unblock(Object var1) {
            AccountMcleaksPane.this.button.setEnabled(true);
        }
    };
    private int currentSession;

    public AccountMcleaksPane(final AccountManagerScene scene, final PaneMode mode) {
        this.scene = scene;
        this.mode = mode;
        this.LOC_PREFIX = "account.manager.multipane.account-mcleaks.";
        ExtendedPanel content = new ExtendedPanel();
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 21;
        c.insets = new Insets(SwingUtil.magnify(5), 0, 0, 0);
        ExtendedPanel bottom = new ExtendedPanel();
        bottom.setLayout(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = -1;
        c1.gridwidth = 1;
        c1.weightx = 1.0;
        c1.fill = 2;
        c1.anchor = 21;
        this.button = new LocalizableButton(this.LOC_PREFIX + "button." + mode.toString().toLowerCase(Locale.ROOT), c);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final int session = new Random().nextInt();
                AccountMcleaksPane.this.currentSession = session;
                String altToken = AccountMcleaksPane.this.newToken.getValue();
                if (StringUtils.isBlank((CharSequence)altToken)) {
                    Alert.showLocError("account.manager.multipane.add-account.error.no-credentials");
                    return;
                }
                Authenticator.instanceFor(() -> new Account<McleaksUser>(AccountManager.getMcleaksAuth().authorize(altToken)), Account.AccountType.MCLEAKS).asyncPass(new AuthUIListener<McleaksUser>((AuthenticatorListener)new AuthenticatorListener<McleaksUser>(){

                    @Override
                    public void onAuthPassing(Authenticator<? extends McleaksUser> var1) {
                        if (AccountMcleaksPane.this.currentSession != session) {
                            return;
                        }
                        Blocker.blockComponents(AccountMcleaksPane.this, "mcleaks-auth");
                        AccountMcleaksPane.this.progressBar.setIndeterminate(true);
                    }

                    @Override
                    public void onAuthPassingError(Authenticator<? extends McleaksUser> var1, Throwable var2) {
                        if (AccountMcleaksPane.this.currentSession != session) {
                            return;
                        }
                        Blocker.unblockComponents(AccountMcleaksPane.this, "mcleaks-auth");
                        AccountMcleaksPane.this.progressBar.setIndeterminate(false);
                        Stats.accountCreation("mcleaks", "standard", "", false);
                    }

                    @Override
                    public void onAuthPassed(Authenticator<? extends McleaksUser> var1) {
                        Account<? extends User> acc;
                        if (AccountMcleaksPane.this.currentSession != session) {
                            return;
                        }
                        Blocker.unblockComponents(AccountMcleaksPane.this, "mcleaks-auth");
                        McleaksUser oldUser = null;
                        if (mode == PaneMode.EDIT && (acc = scene.list.getSelected()) != null && acc.getType() == Account.AccountType.MCLEAKS) {
                            oldUser = (McleaksUser)acc.getUser();
                        }
                        AccountMcleaksPane.this.progressBar.setIndeterminate(false);
                        McleaksUser user = var1.getAccount().getUser();
                        if (oldUser != null) {
                            if (oldUser.equals((Object)user)) {
                                oldUser.setAltToken(user.getAltToken());
                            } else if (Alert.showLocQuestion(AccountMcleaksPane.this.LOC_PREFIX + "overwrite", (Object)user.getUsername())) {
                                TLauncher.getInstance().getProfileManager().getAccountManager().getUserSet().remove(oldUser);
                            }
                        }
                        TLauncher.getInstance().getProfileManager().getAccountManager().getUserSet().add(user);
                        scene.list.select(new Account<McleaksUser>(user));
                        scene.multipane.showTip("success-" + mode.toString().toLowerCase(Locale.ROOT));
                        Stats.accountCreation("mcleaks", "standard", "", true);
                    }
                }){
                    {
                        this.editorOpened = true;
                    }
                });
            }
        });
        this.button.setFont(this.button.getFont().deriveFont(1));
        this.button.setIcon(Images.getIcon24("logo-mcleaks"));
        ++c1.gridy;
        bottom.add((Component)this.button, c1);
        if (McleaksManager.isUnsupported()) {
            Blocker.block(this.buttonBlocker, "mcleaks-unsupported");
        }
        switch (mode) {
            case ADD: {
                this.username = null;
                this.oldToken = null;
                ++c.gridy;
                content.add((Component)new LocalizableLabel(this.LOC_PREFIX + "token"), c);
                this.newToken = new LocalizableTextField();
                this.newToken.setFont(this.newToken.getFont().deriveFont(this.newToken.getFont().getSize2D() + 2.0f));
                this.newToken.setPlaceholder(this.LOC_PREFIX + "token.placeholder");
                ++c.gridy;
                content.add((Component)this.newToken, c);
                LocalizableButton getTokenButton = new LocalizableButton(this.LOC_PREFIX + "button.get-token");
                getTokenButton.addActionListener(e -> OS.openLink("https://mcleaks.net/get"));
                ++c1.gridy;
                bottom.add((Component)getTokenButton, c1);
                break;
            }
            case EDIT: {
                ++c.gridy;
                content.add((Component)new LocalizableLabel(this.LOC_PREFIX + "username"), c);
                this.username = new LocalizableTextField();
                this.username.setEditable(false);
                ++c.gridy;
                content.add((Component)this.username, c);
                ++c.gridy;
                content.add((Component)new LocalizableLabel(this.LOC_PREFIX + "oldToken"), c);
                this.oldToken = new LocalizableTextField();
                this.oldToken.addMouseListener(new TextPopup());
                this.oldToken.setEditable(false);
                ++c.gridy;
                content.add((Component)this.oldToken, c);
                ++c.gridy;
                content.add((Component)new LocalizableLabel(this.LOC_PREFIX + "newToken"), c);
                this.newToken = new LocalizableTextField();
                this.newToken.setPlaceholder(this.LOC_PREFIX + "token.placeholder");
                ++c.gridy;
                BorderPanel panel = new BorderPanel();
                panel.setInsets(0, 0, 0, 0);
                panel.setCenter(this.newToken);
                LocalizableButton b = new LocalizableButton(this.LOC_PREFIX + "newToken.renew");
                b.addActionListener(e -> OS.openLink("https://mcleaks.net/renew"));
                panel.setEast(b);
                ++c.gridy;
                content.add((Component)panel, c);
                LocalizableButton removeButton = new LocalizableButton("account.manager.multipane.remove-account");
                removeButton.addActionListener(e -> {
                    Account<? extends User> account = scene.list.getSelected();
                    if (account != null && account.getType().equals((Object)Account.AccountType.MCLEAKS)) {
                        TLauncher.getInstance().getProfileManager().getAccountManager().getUserSet().remove(account.getUser());
                        scene.multipane.showTip("welcome");
                    }
                });
                ++c1.gridy;
                bottom.add((Component)removeButton, c1);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown mode: " + (Object)((Object)mode));
            }
        }
        this.newToken.addMouseListener(new TextPopup());
        this.progressBar = new ProgressBar();
        this.progressBar.setPreferredSize(new Dimension(1, 10));
        ++c1.gridy;
        bottom.add((Component)this.progressBar, c1);
        this.setCenter(content);
        this.setSouth(bottom);
    }

    @Override
    public void multipaneShown(boolean gotBack) {
        switch (this.mode) {
            case ADD: {
                this.newToken.setValue((Object)null);
                break;
            }
            case EDIT: {
                Account<? extends User> account = this.scene.list.getSelected();
                if (account == null || account.getType() != Account.AccountType.MCLEAKS) {
                    return;
                }
                this.username.setValue((Object)account.getUsername());
                this.oldToken.setValue((Object)((McleaksUser)account.getUser()).getAltToken());
                this.newToken.setValue((Object)null);
            }
        }
    }

    @Override
    public void multipaneClosed() {
        Blocker.unblockComponents(this, "mcleaks-auth");
        this.currentSession = -1;
    }

    @Override
    public Component multipaneComp() {
        return this;
    }

    @Override
    public String multipaneName() {
        return (this.mode == PaneMode.ADD ? "process" : this.mode.toString().toLowerCase(Locale.ROOT)) + "-account-mcleaks";
    }

    @Override
    public boolean multipaneLocksView() {
        return true;
    }

    @Override
    public void block(Object var1) {
        Blocker.block(this.buttonBlocker, var1);
        Blocker.blockComponents(var1, this.getComponents());
    }

    @Override
    public void unblock(Object var1) {
        Blocker.unblock(this.buttonBlocker, var1);
        Blocker.unblockComponents(var1, this.getComponents());
    }
}

