/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.account;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.Locale;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.managers.ProfileManager;
import ru.turikhay.tlauncher.managers.ProfileManagerListener;
import ru.turikhay.tlauncher.managers.SwingProfileManagerListener;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.minecraft.auth.AccountListener;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorDatabase;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.center.CenterPanel;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.scenes.AccountManagerScene;
import ru.turikhay.tlauncher.ui.swing.AccountCellRenderer;
import ru.turikhay.tlauncher.ui.swing.ScrollPane;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.user.User;

public class AccountList
extends CenterPanel
implements ProfileManagerListener,
AccountListener,
Blockable {
    private final AccountManagerScene scene;
    private final DefaultListModel<Account<? extends User>> accountModel;
    private final JList<Account<? extends User>> list;
    private final LocalizableButton add;
    private final LocalizableButton edit;

    public AccountList(AccountManagerScene scene) {
        super(squareInsets);
        this.scene = scene;
        BorderPanel wrapper = new BorderPanel();
        wrapper.setVgap(5);
        this.accountModel = new DefaultListModel();
        this.list = new JList<Account<? extends User>>(this.accountModel);
        this.list.setCellRenderer(new AccountCellRenderer(AccountCellRenderer.AccountCellType.EDITOR));
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(e -> {
            if ("success".equals(scene.multipane.currentTip())) {
                scene.multipane.showTip("welcome");
            }
        });
        ScrollPane scrollPane = new ScrollPane(this.list);
        scrollPane.setHBPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setVBPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        wrapper.setCenter(scrollPane);
        ExtendedPanel buttons = new ExtendedPanel();
        buttons.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 1.0;
        c.fill = 2;
        ExtendedPanel firstLineButtons = new ExtendedPanel(new GridLayout(0, 3));
        ++c.gridy;
        buttons.add((Component)firstLineButtons, c);
        this.add = new LocalizableButton(Images.getIcon24("plus-square"), "account.button.add");
        this.add.addActionListener(e -> this.scene.multipane.showTip("add-account"));
        firstLineButtons.add((Component)this.add);
        this.edit = new LocalizableButton(Images.getIcon24("pencil-square"), "account.button.remove");
        this.edit.addActionListener(e -> {
            if (scene.list.getSelected() != null) {
                scene.multipane.showTip("edit-account-" + scene.list.getSelected().getType().toString().toLowerCase(Locale.ROOT));
            }
        });
        firstLineButtons.add((Component)this.edit);
        LocalizableButton back = new LocalizableButton(Images.getIcon24("home"), "account.button.home");
        back.addActionListener(e -> TLauncher.getInstance().getFrame().mp.openDefaultScene());
        firstLineButtons.add((Component)back);
        wrapper.setSouth(buttons);
        this.add((Component)wrapper);
        TLauncher.getInstance().getProfileManager().addListener(new SwingProfileManagerListener(this));
    }

    public Account<? extends User> getSelected() {
        return this.list.getSelectedValue();
    }

    public void select(Account<? extends User> account) {
        this.list.setSelectedValue(account, true);
    }

    public void updateList() {
        this.onAccountsRefreshed(TLauncher.getInstance().getProfileManager().getAuthDatabase());
    }

    @Override
    public void onAccountsRefreshed(AuthenticatorDatabase db) {
        this.accountModel.clear();
        for (Account<? extends User> account : db.getAccounts()) {
            this.accountModel.addElement(account);
        }
    }

    @Override
    public void onProfilesRefreshed(ProfileManager var1) {
        this.onAccountsRefreshed(var1.getAuthDatabase());
    }

    @Override
    public void onProfileManagerChanged(ProfileManager var1) {
        this.onAccountsRefreshed(var1.getAuthDatabase());
    }

    @Override
    public void block(Object reason) {
        Blocker.blockComponents(reason, this.list, this.add, this.edit);
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblockComponents(reason, this.list, this.add, this.edit);
    }
}

