/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.account;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JPopupMenu;
import ru.turikhay.tlauncher.ui.account.AccountMultipaneCompCloseable;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.scenes.AccountManagerScene;
import ru.turikhay.tlauncher.ui.swing.editor.EditorPane;
import ru.turikhay.tlauncher.ui.swing.editor.ExtendedHTMLEditorKit;
import ru.turikhay.tlauncher.ui.swing.editor.HyperlinkProcessor;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.ui.swing.extended.HtmlSubstitutor;
import ru.turikhay.util.git.TokenReplacingReader;

public class AccountElyStart
extends BorderPanel
implements AccountMultipaneCompCloseable,
LocalizableComponent {
    private final String LOC_PREFIX = "account.manager.multipane." + this.multipaneName() + ".";
    private final LocalizableButton button;
    private final EditorPane content = new EditorPane();
    private StartState state;

    public AccountElyStart(final AccountManagerScene scene) {
        ((ExtendedHTMLEditorKit)this.content.getEditorKit()).setHyperlinkProcessor(new HyperlinkProcessor(){

            @Override
            public JPopupMenu process(String link) {
                if (link != null && link.startsWith("internal:tip:")) {
                    String tip = link.substring("internal:tip:".length());
                    scene.multipane.showTip(tip);
                    return null;
                }
                return HyperlinkProcessor.defaultProcessor.process(link);
            }
        });
        this.setCenter(this.content);
        ExtendedPanel panel = new ExtendedPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 2;
        c.gridy = -1;
        this.button = new LocalizableButton();
        this.button.addActionListener(e -> {
            switch (this.state) {
                case DESCRIPTION: {
                    this.setState(StartState.GET_READY);
                    break;
                }
                case GET_READY: {
                    scene.multipane.showTip("process-account-ely");
                }
            }
        });
        this.button.setIcon(Images.getIcon24("logo-ely"));
        this.button.setFont(this.button.getFont().deriveFont(1));
        ++c.gridy;
        panel.add((Component)this.button, c);
        this.setSouth(panel);
        this.setState(StartState.DESCRIPTION);
    }

    private void setState(StartState state) {
        this.state = Objects.requireNonNull(state, "state");
        this.button.setText(this.LOC_PREFIX + state.toString().toLowerCase(Locale.ROOT) + ".button");
        this.content.setText(TokenReplacingReader.resolveVars(Localizable.get(this.LOC_PREFIX + state.toString().toLowerCase(Locale.ROOT) + ".body"), new HtmlSubstitutor()));
    }

    @Override
    public void setMaximumSize(Dimension maximumSize) {
        super.setMaximumSize(maximumSize);
        this.content.setPreferredSize(new Dimension(0, 0));
    }

    @Override
    public void multipaneClosed() {
    }

    @Override
    public Component multipaneComp() {
        return this;
    }

    @Override
    public String multipaneName() {
        return "add-account-ely";
    }

    @Override
    public boolean multipaneLocksView() {
        return true;
    }

    @Override
    public void multipaneShown(boolean gotBack) {
        this.setState(StartState.DESCRIPTION);
    }

    @Override
    public void updateLocale() {
        this.setState(this.state);
    }

    private static enum StartState {
        DESCRIPTION,
        GET_READY;

    }
}

