/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.account;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.Future;
import javax.swing.JPopupMenu;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.managers.AccountManager;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.stats.Stats;
import ru.turikhay.tlauncher.ui.account.AccountMultipaneCompCloseable;
import ru.turikhay.tlauncher.ui.account.StandardAccountPane;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.progress.ProgressBar;
import ru.turikhay.tlauncher.ui.scenes.AccountManagerScene;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.user.ElyAuthCode;
import ru.turikhay.tlauncher.user.ElyAuthFlow;
import ru.turikhay.tlauncher.user.ElyFlowWaitTask;
import ru.turikhay.tlauncher.user.ElyUser;
import ru.turikhay.tlauncher.user.FallbackElyAuthFlow;
import ru.turikhay.tlauncher.user.FallbackElyAuthFlowListener;
import ru.turikhay.tlauncher.user.PrimaryElyAuthFlow;
import ru.turikhay.tlauncher.user.PrimaryElyAuthFlowListener;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.async.AsyncThread;

public class AccountElyProcess
extends BorderPanel
implements AccountMultipaneCompCloseable {
    private static final Logger LOGGER = LogManager.getLogger(AccountElyProcess.class);
    private final String LOC_PREFIX = "account.manager.multipane." + this.multipaneName() + ".";
    private final AccountManagerScene scene;
    private final ProgressBar progressBar;
    private final LocalizableLabel label;
    private final LocalizableButton button;
    private final LocalizableMenuItem fallbackMenuItem;
    private Future<ElyAuthCode> authProcess;
    private ElyUser user;

    public AccountElyProcess(AccountManagerScene scene) {
        this.scene = scene;
        ExtendedPanel panel = new ExtendedPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 2;
        c.gridy = -1;
        this.progressBar = new ProgressBar();
        this.progressBar.setPreferredSize(SwingUtil.magnify(new Dimension(1, 24)));
        this.progressBar.setIndeterminate(true);
        ++c.gridy;
        panel.add((Component)this.progressBar, c);
        this.label = new LocalizableLabel(this.LOC_PREFIX + "waiting");
        ++c.gridy;
        panel.add((Component)this.label, c);
        this.setCenter(panel);
        JPopupMenu menu = new JPopupMenu();
        this.fallbackMenuItem = LocalizableMenuItem.newItem(this.LOC_PREFIX + "failed.fallback", e -> this.activateFallbackFlow());
        menu.add(this.fallbackMenuItem);
        menu.add(LocalizableMenuItem.newItem(this.LOC_PREFIX + "failed.classic", e -> {
            this.cancelCurrentFlow();
            scene.multipane.clearBreadcrumbs();
            scene.multipane.showTip("add-account-ely_legacy");
        }));
        this.button = new LocalizableButton();
        this.button.addActionListener(e -> menu.show(this.button, 0, this.button.getHeight()));
        this.button.setIcon(Images.getIcon24("warning-2"));
        this.button.setIconTextGap(SwingUtil.magnify(10));
        this.button.setText(this.LOC_PREFIX + "failed");
        this.setSouth(this.button);
    }

    private void setState(FlowState state) {
        String labelText;
        int progress = -1;
        boolean helpEnabled = true;
        switch (state) {
            case INIT: {
                labelText = "init";
                break;
            }
            case WAITING: {
                labelText = "waiting";
                break;
            }
            case CANCELLED: {
                labelText = "cancelled";
                progress = 0;
                break;
            }
            case INPUT_WAITING: {
                labelText = "input_waiting";
                break;
            }
            case EXCHANGE: {
                labelText = "exchange";
                helpEnabled = false;
                break;
            }
            case ERROR: {
                labelText = "error";
                progress = 0;
                break;
            }
            case COMPLETE: {
                labelText = "complete";
                progress = 1;
                helpEnabled = false;
                break;
            }
            default: {
                return;
            }
        }
        this.label.setText(this.LOC_PREFIX + "flow." + labelText);
        switch (progress) {
            case -1: {
                this.progressBar.setIndeterminate(true);
                break;
            }
            case 0: {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setValue(0);
                break;
            }
            case 1: {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setValue(100);
            }
        }
        this.button.setEnabled(helpEnabled);
    }

    private void activatePrimaryFlow() {
        this.cancelCurrentFlow();
        this.setState(FlowState.INIT);
        this.fallbackMenuItem.setEnabled(true);
        PrimaryElyAuthFlow primaryFlow = AccountManager.getElyAuth().getPrimaryFlow();
        primaryFlow.registerListener(new PrimaryElyAuthFlowListener(){

            @Override
            public void primaryStrategyServerCreated(PrimaryElyAuthFlow strategy, int port) {
                AccountElyProcess.this.setState(FlowState.INIT);
            }

            @Override
            public void primaryStrategyUrlOpened(PrimaryElyAuthFlow strategy, URL url) {
                AccountElyProcess.this.setState(FlowState.WAITING);
            }

            @Override
            public ElyFlowWaitTask<Boolean> primaryStrategyCodeParseFailed(PrimaryElyAuthFlow strategy, URI uri) {
                return null;
            }

            @Override
            public void strategyStarted(ElyAuthFlow<?> strategy) {
                AccountElyProcess.this.setState(FlowState.INIT);
            }

            @Override
            public void strategyErrored(ElyAuthFlow<?> strategy, Exception e) {
                Stats.accountCreation("ely", "primary", "", false);
                AccountElyProcess.this.setState(FlowState.ERROR);
            }

            @Override
            public void strategyUrlOpened(ElyAuthFlow<?> strategy, URL url) {
                AccountElyProcess.this.setState(FlowState.WAITING);
            }

            @Override
            public void strategyUrlOpeningFailed(ElyAuthFlow<?> strategy, URL url) {
                Stats.accountCreation("ely", "primary", "url_opening", false);
                AccountElyProcess.this.setState(FlowState.ERROR);
            }

            @Override
            public void strategyCancelled(ElyAuthFlow<?> strategy) {
                Stats.accountCreation("ely", "primary", "cancelled", false);
                AccountElyProcess.this.setState(FlowState.CANCELLED);
            }

            @Override
            public void strategyComplete(ElyAuthFlow<?> strategy, ElyAuthCode code) {
                AccountElyProcess.this.fetchCode("primary", code);
                Stats.accountCreation("ely", "primary", "", true);
            }
        });
        this.authProcess = AsyncThread.future(primaryFlow);
    }

    private void activateFallbackFlow() {
        this.cancelCurrentFlow();
        this.setState(FlowState.INIT);
        this.fallbackMenuItem.setEnabled(false);
        FallbackElyAuthFlow fallbackFlow = AccountManager.getElyAuth().getFallbackFlow();
        fallbackFlow.registerListener(new FallbackElyAuthFlowListener(){

            @Override
            public ElyFlowWaitTask<String> fallbackStrategyRequestedInput(FallbackElyAuthFlow strategy) {
                AccountElyProcess.this.setState(FlowState.INPUT_WAITING);
                return () -> Alert.showLocInputQuestion("account.manager.multipane.process-account-ely.flow.input_waiting.alert");
            }

            @Override
            public void strategyStarted(ElyAuthFlow<?> strategy) {
                AccountElyProcess.this.setState(FlowState.INIT);
            }

            @Override
            public void strategyErrored(ElyAuthFlow<?> strategy, Exception e) {
                Stats.accountCreation("ely", "fallback", "", false);
                AccountElyProcess.this.setState(FlowState.ERROR);
            }

            @Override
            public void strategyUrlOpened(ElyAuthFlow<?> strategy, URL url) {
                AccountElyProcess.this.setState(FlowState.WAITING);
            }

            @Override
            public void strategyUrlOpeningFailed(ElyAuthFlow<?> strategy, URL url) {
                Stats.accountCreation("ely", "fallback", "url_opening", false);
                AccountElyProcess.this.setState(FlowState.ERROR);
            }

            @Override
            public void strategyCancelled(ElyAuthFlow<?> strategy) {
                Stats.accountCreation("ely", "fallback", "cancelled", false);
                AccountElyProcess.this.setState(FlowState.CANCELLED);
            }

            @Override
            public void strategyComplete(ElyAuthFlow<?> strategy, ElyAuthCode code) {
                Stats.accountCreation("ely", "fallback", "", true);
                AccountElyProcess.this.fetchCode("fallback", code);
            }
        });
        this.authProcess = AsyncThread.future(fallbackFlow);
    }

    private void fetchCode(String strategy, ElyAuthCode code) {
        ElyUser user;
        this.setState(FlowState.EXCHANGE);
        TLauncher.getInstance().getFrame().requestFocus();
        TLauncher.getInstance().getFrame().toFront();
        try {
            user = code.getUser();
        }
        catch (Exception e) {
            LOGGER.error("Could not get user", (Throwable)e);
            this.setState(FlowState.ERROR);
            return;
        }
        this.setState(FlowState.COMPLETE);
        StandardAccountPane.removeAccountIfFound(user.getUsername(), Account.AccountType.ELY);
        StandardAccountPane.removeAccountIfFound(user.getUsername(), Account.AccountType.ELY_LEGACY);
        TLauncher.getInstance().getProfileManager().getAccountManager().getUserSet().add(user);
        this.scene.multipane.showTip("success-add");
        this.scene.list.select(new Account<ElyUser>(user));
    }

    private void cancelCurrentFlow() {
        if (this.authProcess != null) {
            this.authProcess.cancel(true);
        }
    }

    @Override
    public void multipaneClosed() {
        this.cancelCurrentFlow();
    }

    @Override
    public Component multipaneComp() {
        return this;
    }

    @Override
    public String multipaneName() {
        return "process-account-ely";
    }

    @Override
    public boolean multipaneLocksView() {
        return true;
    }

    @Override
    public void multipaneShown(boolean gotBack) {
        this.activatePrimaryFlow();
    }

    public static enum FlowState {
        INIT,
        WAITING,
        CANCELLED,
        INPUT_WAITING,
        EXCHANGE,
        ERROR,
        COMPLETE;

    }
}

