/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.account;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Optional;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.configuration.LangConfiguration;
import ru.turikhay.tlauncher.managers.PromotedStoreManager;
import ru.turikhay.tlauncher.stats.Stats;
import ru.turikhay.tlauncher.ui.account.AccountMultipaneCompCloseable;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.frames.RequireMinecraftAccountFrame;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.scenes.AccountManagerScene;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.user.UserSet;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;

public class AccountAdd
extends BorderPanel
implements AccountMultipaneCompCloseable,
Blockable,
LocalizableComponent {
    private final AccountManagerScene scene;
    private final ExtendedPanel grid;
    private final GridBagConstraints c;
    private final LocalizableButton minecraft;
    private final LocalizableButton ely;
    private final LocalizableButton free;
    private final LocalizableButton idontknow;
    private final LocalizableButton promotedStore;
    private final boolean requireMinecraftAccount;
    private final String LOC_PREFIX;

    public AccountAdd(AccountManagerScene scene) {
        this.scene = scene;
        this.requireMinecraftAccount = TLauncher.getInstance().getCapability("require_minecraft_account", Boolean.class).orElse(false);
        this.grid = new ExtendedPanel();
        this.grid.setAlignmentX(0.0f);
        this.grid.setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.anchor = 21;
        this.c.gridy = -1;
        this.LOC_PREFIX = "account.manager.multipane." + this.multipaneName() + ".";
        String ACCOUNT_TYPE_PREFIX = this.LOC_PREFIX + "type.";
        this.ely = this.addRow("logo-ely", ACCOUNT_TYPE_PREFIX + "ely", this.createListenerFor("add-account-ely", false));
        this.minecraft = this.addRow("logo-microsoft", ACCOUNT_TYPE_PREFIX + "minecraft", this.createListenerFor("process-account-minecraft", true));
        this.promotedStore = this.addRow("gift-1", this.LOC_PREFIX + "buy-minecraft", e -> {
            String url = "https://minecraft.net";
            boolean promotedStore = false;
            Optional<String> urlOpt = this.psm().getInfoNow().map(PromotedStoreManager.Info::getUrl);
            if (urlOpt.isPresent()) {
                url = urlOpt.get();
                promotedStore = true;
            }
            Stats.showInterestInBuying(promotedStore);
            OS.openLink(url);
        });
        this.free = this.addRow("user-circle-o", ACCOUNT_TYPE_PREFIX + "free", this.createListenerFor("add-account-plain", false));
        this.idontknow = this.addRow("info-circle", this.LOC_PREFIX + "hint", e -> Blocker.toggle(this, "idontknow"));
        ++this.c.gridy;
        this.c.gridx = 1;
        this.c.fill = 3;
        this.c.insets = new Insets(0, 0, 0, 0);
        this.c.weighty = 1.0;
        this.grid.add((Component)new ExtendedPanel(), this.c);
        this.setCenter(this.grid);
        this.updateLocale();
    }

    private ActionListener createListenerFor(String name, boolean isMinecraftAccount) {
        return e -> {
            if (this.requireMinecraftAccount && !isMinecraftAccount) {
                UserSet userSet = TLauncher.getInstance().getProfileManager().getAccountManager().getUserSet();
                boolean hasMinecraftAccount = userSet.findByType("minecraft").isPresent();
                boolean hasMojangAccount = userSet.findByType("mojang").isPresent();
                if (!hasMinecraftAccount && !hasMojangAccount) {
                    new RequireMinecraftAccountFrame().showAtCenter();
                    return;
                }
            }
            this.scene.multipane.showTip(name);
        };
    }

    private LocalizableButton addRow(String image, String label, ActionListener action) {
        ++this.c.gridy;
        LocalizableButton button = new LocalizableButton(label);
        button.setHorizontalAlignment(2);
        button.setIconTextGap(SwingUtil.magnify(16));
        button.addActionListener(action);
        button.setIcon(Images.getIcon32(image));
        this.c.gridx = 0;
        this.c.weightx = 1.0;
        this.c.gridwidth = 0;
        this.c.insets = new Insets(SwingUtil.magnify(5), 0, 0, 0);
        this.c.fill = 2;
        this.grid.add((Component)button, this.c);
        return button;
    }

    @Override
    public Component multipaneComp() {
        return this;
    }

    @Override
    public String multipaneName() {
        return "add-account";
    }

    @Override
    public boolean multipaneLocksView() {
        return true;
    }

    @Override
    public void multipaneShown(boolean gotBack) {
        Blocker.unblock(this, "idontknow");
    }

    @Override
    public void multipaneClosed() {
        Blocker.unblock(this, "idontknow");
    }

    @Override
    public void block(Object var1) {
        if (!"idontknow".equals(var1)) {
            Blocker.blockComponents(var1, this.free, this.ely, this.idontknow, this.minecraft);
        }
        if (this.requireMinecraftAccount) {
            Blocker.blockComponents(var1, this.free, this.ely);
        } else {
            Blocker.blockComponents(var1, this.ely, this.minecraft);
        }
    }

    @Override
    public void unblock(Object var1) {
        Blocker.unblockComponents(var1, this.free, this.ely, this.idontknow, this.minecraft);
    }

    @Override
    public void updateLocale() {
        if (!this.scene.getMainPane().getRootFrame().getLauncher().getLang().getLocale().equals(LangConfiguration.ru_RU)) {
            this.promotedStore.setEnabled(true);
            return;
        }
        this.promotedStore.setEnabled(false);
        this.psm().requestOrGetInfo().whenComplete((info, t) -> {
            if (info != null) {
                SwingUtil.later(() -> this.promotedStore.setText(this.LOC_PREFIX + "buy-minecraft-price", info.getPrice()));
            }
            SwingUtil.later(() -> this.promotedStore.setEnabled(true));
        });
    }

    private PromotedStoreManager psm() {
        return this.scene.getMainPane().getRootFrame().getLauncher().getPromotedStoreManager();
    }
}

