/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.configuration.LangConfiguration;
import ru.turikhay.tlauncher.configuration.SimpleConfiguration;
import ru.turikhay.tlauncher.ui.MainPane;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.frames.FeedbackFrame;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.notice.NoticeManager;
import ru.turikhay.tlauncher.ui.swing.Dragger;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedComponentAdapter;
import ru.turikhay.tlauncher.ui.theme.Theme;
import ru.turikhay.util.IntegerArray;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.U;
import ru.turikhay.util.async.ExtendedThread;

public class TLauncherFrame
extends JFrame {
    private static final Logger LOGGER = LogManager.getLogger(TLauncherFrame.class);
    public static final Dimension minSize = new Dimension(700, 600);
    public static final Dimension maxSize = new Dimension(1920, 1080);
    public static final float minFontSize = 12.0f;
    public static final float maxFontSize = 18.0f;
    private static float fontSize = 12.0f;
    public static double magnifyDimensions = 1.0;
    private final TLauncherFrame instance = this;
    private final TLauncher tlauncher;
    private final Configuration settings;
    private final LangConfiguration lang;
    private final int[] windowSize;
    private final Point maxPoint;
    public final MainPane mp;
    private String brand;
    private SimpleConfiguration proofr;
    private SimpleConfiguration uiConfig;
    private final NoticeManager notices;

    public static float getFontSize() {
        return fontSize;
    }

    public static void setFontSize(float size) {
        fontSize = size;
        magnifyDimensions = fontSize * 16.0f / 12.0f / 16.0f;
    }

    public TLauncherFrame(TLauncher t) {
        this.tlauncher = t;
        this.settings = t.getSettings();
        this.lang = t.getLang();
        this.windowSize = this.settings.getLauncherWindowSize();
        this.maxPoint = new Point();
        SwingUtil.initFontSize((int)TLauncherFrame.getFontSize());
        SwingUtil.setFavicons(this);
        this.setupUI();
        this.updateUILocale();
        this.setWindowSize();
        this.setWindowTitle();
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowIconified(WindowEvent e) {
                TLauncherFrame.this.mp.background.pauseBackground();
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                TLauncherFrame.this.mp.background.startBackground();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                TLauncherFrame.this.mp.background.startBackground();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                TLauncherFrame.this.mp.background.pauseBackground();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (!TLauncherFrame.this.settings.getBoolean("feedback") && TLauncherFrame.this.tlauncher.getBootConfig().getFeedback() != null) {
                    String url;
                    if (TLauncherFrame.this.tlauncher.getBootConfig().getFeedback().containsKey(TLauncherFrame.this.tlauncher.getSettings().getLocale().toString())) {
                        url = TLauncherFrame.this.tlauncher.getBootConfig().getFeedback().get(TLauncherFrame.this.tlauncher.getSettings().getLocale().toString());
                    } else if (TLauncherFrame.this.tlauncher.getBootConfig().getFeedback().containsKey("global")) {
                        url = TLauncherFrame.this.tlauncher.getBootConfig().getFeedback().get("global");
                    } else {
                        TLauncherFrame.this.instance.setVisible(false);
                        TLauncher.kill();
                        return;
                    }
                    TLauncherFrame.this.settings.set("feedback", (Object)true);
                    new FeedbackFrame(TLauncherFrame.this, url);
                }
            }
        });
        this.addComponentListener(new ExtendedComponentAdapter(this){

            @Override
            public void onComponentResized(ComponentEvent e) {
                TLauncherFrame.this.updateMaxPoint();
                Dragger.update();
                if (TLauncherFrame.this.mp != null && TLauncherFrame.this.mp.defaultScene != null) {
                    boolean lock = TLauncherFrame.this.getExtendedState() != 0;
                    IntegerArray arr = new IntegerArray(TLauncherFrame.this.getWidth(), TLauncherFrame.this.getHeight());
                    if (TLauncherFrame.this.mp.defaultScene.settingsForm.isLoaded()) {
                        Blocker.setBlocked(TLauncherFrame.this.mp.defaultScene.settingsForm.get().launcherResolution, "extended", lock);
                        if (!lock) {
                            TLauncherFrame.this.mp.defaultScene.settingsForm.get().launcherResolution.setValue(arr);
                        }
                    }
                    if (!lock) {
                        TLauncherFrame.this.settings.set("gui.size", arr);
                    }
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                TLauncherFrame.this.instance.validate();
                TLauncherFrame.this.instance.repaint();
                TLauncherFrame.this.instance.toFront();
                TLauncherFrame.this.mp.background.startBackground();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                TLauncherFrame.this.mp.background.pauseBackground();
            }
        });
        this.addWindowStateListener(e -> {
            int newState = TLauncherFrame.getExtendedStateFor(e.getNewState());
            if (newState != -1) {
                this.settings.set("gui.window", newState);
            }
        });
        this.notices = new NoticeManager(this, t.getBootConfig());
        this.mp = new MainPane(this);
        this.add(this.mp);
        LOGGER.trace("Packing main frame...");
        this.pack();
        LOGGER.trace("Resizing main pane...");
        this.mp.onResize();
        this.mp.background.loadBackground();
        this.updateMaxPoint();
        Dragger.ready(this.settings, this.maxPoint);
        if (TLauncher.getInstance().isDebug()) {
            new TitleUpdaterThread();
        } else {
            this.setWindowTitle();
        }
        SwingUtilities.invokeLater(() -> {
            try {
                this.setVisible(true);
            }
            catch (RuntimeException rE) {
                LOGGER.warn("Hidden exception on setVisible(true)", (Throwable)rE);
            }
            int windowState = TLauncherFrame.getExtendedStateFor(this.settings.getInteger("gui.window"));
            if (windowState == 0) {
                this.setLocationRelativeTo(null);
            } else {
                this.setExtendedState(windowState);
            }
        });
    }

    public TLauncher getLauncher() {
        return this.tlauncher;
    }

    public NoticeManager getNotices() {
        return this.notices;
    }

    public Point getMaxPoint() {
        return this.maxPoint;
    }

    public Configuration getConfiguration() {
        return this.settings;
    }

    public void updateLocales() {
        try {
            this.tlauncher.reloadLocale();
        }
        catch (Exception var2) {
            LOGGER.warn("Cannot reload settings", (Throwable)var2);
            return;
        }
        LocalizableMenuItem.updateLocales();
        this.updateUILocale();
        this.notices.updateLocale();
        Localizable.updateContainer(this);
        this.setWindowTitle();
    }

    public void updateTitle() {
        StringBuilder brandBuilder = new StringBuilder();
        if (!TLauncher.getInstance().isDebug()) {
            brandBuilder.append(U.getMinorVersion(TLauncher.getVersion())).append(" ");
        }
        brandBuilder.append("[").append(TLauncher.getBrand()).append("]");
        if (TLauncher.getInstance().isDebug()) {
            brandBuilder.append(" [DEBUG]");
        }
        this.brand = brandBuilder.toString();
    }

    public void setWindowTitle() {
        this.updateTitle();
        String title = TLauncher.getInstance().isDebug() ? String.format(Locale.ROOT, "Legacy Launcher %s [%s]", this.brand, U.memoryStatus()) : String.format(Locale.ROOT, "Legacy Launcher %s", this.brand);
        this.setTitle(title);
    }

    private void setWindowSize() {
        int width = Math.min(this.windowSize[0], TLauncherFrame.maxSize.width);
        int height = Math.min(this.windowSize[1], TLauncherFrame.maxSize.height);
        Dimension curSize = new Dimension(width, height);
        this.setMinimumSize(SwingUtil.magnify(minSize));
        this.setPreferredSize(curSize);
    }

    private void setupUI() {
        if (OS.WINDOWS.isCurrent()) {
            UIManager.put("FileChooser.useSystemExtensionHiding", false);
        }
        UIManager.put("FileChooser.newFolderErrorSeparator", ": ");
        UIManager.put("FileChooser.readOnly", Boolean.FALSE);
        UIManager.put("TabbedPane.contentOpaque", Boolean.FALSE);
        UIManager.put("TabbedPane.contentBorderInsets", new Insets(0, 0, 0, 0));
        UIManager.put("TabbedPane.tabInsets", new Insets(0, 8, 6, 8));
        String themeFile = this.settings.get("gui.theme");
        String name = null;
        try {
            InputStream in;
            if (themeFile != null && new File(themeFile).isFile()) {
                name = themeFile;
                in = new FileInputStream(themeFile);
            } else {
                name = "modern";
                in = Theme.class.getResourceAsStream("theme.properties");
            }
            Theme.loadTheme(name, in);
        }
        catch (Exception e) {
            Alert.showError("Could not load theme: " + name, e);
        }
    }

    private void updateUILocale() {
        if (this.uiConfig == null) {
            try {
                this.uiConfig = new SimpleConfiguration(this.getClass().getResource("/lang/_ui.properties"));
            }
            catch (Exception var4) {
                return;
            }
        }
        for (String key : this.uiConfig.getKeys()) {
            String value = this.uiConfig.get(key);
            if (value == null) continue;
            UIManager.put(key, this.lang.get(value));
        }
    }

    private void updateMaxPoint() {
        this.maxPoint.x = this.getWidth();
        this.maxPoint.y = this.getHeight();
    }

    @Override
    public void setSize(int width, int height) {
        if ((this.getWidth() != width || this.getHeight() != height) && this.getExtendedState() == 0) {
            boolean show = this.isVisible();
            if (show) {
                this.setVisible(false);
            }
            super.setSize(width, height);
            if (show) {
                this.setVisible(true);
                this.setLocationRelativeTo(null);
            }
        }
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    private static int getExtendedStateFor(int state) {
        switch (state) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                return state;
            }
        }
        return -1;
    }

    public static URL getRes(String uri) {
        return TLauncherFrame.class.getResource(uri);
    }

    private class TitleUpdaterThread
    extends ExtendedThread {
        TitleUpdaterThread() {
            super("TitleUpdater");
            TLauncherFrame.this.updateTitle();
            this.start();
        }

        @Override
        public void run() {
            while (TLauncherFrame.this.isDisplayable()) {
                U.sleepFor(100L);
                TLauncherFrame.this.setWindowTitle();
            }
            this.interrupt();
        }
    }
}

