/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JSeparator;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.images.FixedSizeImage;
import ru.turikhay.tlauncher.ui.images.ImageIcon;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.loc.LocalizableHTMLLabel;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.swing.editor.EditorPane;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedFrame;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedLabel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.ui.theme.Theme;
import ru.turikhay.tlauncher.user.MojangUser;
import ru.turikhay.tlauncher.user.MojangUserMigrationStatus;
import ru.turikhay.util.Lazy;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;

public class MigrationFrame
extends ExtendedFrame
implements LocalizableComponent {
    private static final int SIZE = SwingUtil.magnify(500);
    private static final int IMAGE_HEIGHT = SIZE / 2;
    private static final int BORDER = SwingUtil.magnify(20);
    private static final int HALF_BORDER = BORDER / 2;
    private static final int QUARTER_BORDER = BORDER / 4;
    private static final int WIDTH_BORDERED = SIZE - BORDER * 2;
    private final EditorPane explanationLabel;
    private final LocalizableHTMLLabel accountsCount;
    private final ExtendedPanel accountsList;
    private Set<MojangUser> accounts;
    private Instant startDate;
    private Instant endDate;
    private final Lazy<DateTimeFormatter> dateFormatter = Lazy.of(() -> DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).withLocale(TLauncher.getInstance().getSettings().getLocale()).withZone(ZoneId.systemDefault()));

    public MigrationFrame() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setIconImages(SwingUtil.createFaviconList("migration-icon"));
        this.setMinimumSize(new Dimension(SIZE, SIZE));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 1.0;
        FixedSizeImage image = new FixedSizeImage(Images.loadImageByName("migration-banner.jpg"));
        image.setPreferredSize(new Dimension(SIZE, IMAGE_HEIGHT));
        c.fill = 1;
        c.weighty = 1.0;
        ++c.gridy;
        this.add((Component)image, c);
        ExtendedPanel container = new ExtendedPanel();
        c.fill = 1;
        c.weighty = 0.0;
        ++c.gridy;
        this.add((Component)container, c);
        container.setLayout(new BoxLayout(container, 1));
        container.setBorder(BorderFactory.createEmptyBorder(BORDER, BORDER, BORDER, BORDER));
        LocalizableLabel head = new LocalizableLabel("mojang-migration.head");
        head.setAlignmentX(0.0f);
        head.setAlignmentY(0.0f);
        head.setFont(head.getFont().deriveFont(1, head.getFont().getSize2D() + 3.0f));
        head.setForeground(Theme.getTheme().getSemiForeground());
        container.add((Component)head);
        container.add(Box.createRigidArea(new Dimension(1, HALF_BORDER)));
        this.explanationLabel = new EditorPane();
        this.explanationLabel.setAlignmentX(0.0f);
        this.explanationLabel.setAlignmentY(0.0f);
        container.add((Component)this.explanationLabel);
        container.add(Box.createRigidArea(new Dimension(1, BORDER)));
        LocalizableLabel yourAccountsHead = new LocalizableLabel("mojang-migration.your-accounts.title");
        yourAccountsHead.setIcon(Images.getIcon24("user-circle-o").getDisabledInstance());
        yourAccountsHead.setIconTextGap(HALF_BORDER);
        yourAccountsHead.setAlignmentX(0.0f);
        yourAccountsHead.setAlignmentY(0.0f);
        yourAccountsHead.setFont(yourAccountsHead.getFont().deriveFont(1, yourAccountsHead.getFont().getSize2D() + 3.0f));
        yourAccountsHead.setForeground(Theme.getTheme().getSemiForeground());
        container.add((Component)yourAccountsHead);
        container.add(Box.createRigidArea(new Dimension(1, HALF_BORDER)));
        this.accountsCount = new LocalizableHTMLLabel();
        this.accountsCount.setLabelWidth(WIDTH_BORDERED);
        this.accountsCount.setAlignmentX(0.0f);
        this.accountsCount.setAlignmentY(0.0f);
        container.add((Component)this.accountsCount);
        this.accountsList = new ExtendedPanel();
        this.accountsList.setLayout(new BoxLayout(this.accountsList, 1));
        this.accountsList.setAlignmentX(0.0f);
        this.accountsList.setAlignmentY(0.0f);
        this.accountsList.add((Component)new ExtendedLabel("..."));
        container.add((Component)this.accountsList);
        container.add(Box.createRigidArea(new Dimension(1, BORDER)));
        LocalizableLabel notificationTitle = new LocalizableLabel("mojang-migration.notifications.title");
        notificationTitle.setIcon(Images.getIcon24("info-circle-2").getDisabledInstance());
        notificationTitle.setIconTextGap(HALF_BORDER);
        notificationTitle.setAlignmentX(0.0f);
        notificationTitle.setAlignmentY(0.0f);
        notificationTitle.setFont(notificationTitle.getFont().deriveFont(1, notificationTitle.getFont().getSize2D() + 3.0f));
        notificationTitle.setForeground(Theme.getTheme().getSemiForeground());
        container.add((Component)notificationTitle);
        container.add(Box.createRigidArea(new Dimension(1, HALF_BORDER)));
        LocalizableHTMLLabel notificationLabel = new LocalizableHTMLLabel("mojang-migration.notifications.body");
        notificationLabel.setLabelWidth(WIDTH_BORDERED);
        notificationLabel.setAlignmentX(0.0f);
        notificationLabel.setAlignmentY(0.0f);
        container.add((Component)notificationLabel);
        this.updateLocale();
    }

    public void updateUsers(Set<MojangUser> users, Instant startDate, Instant endDate) {
        this.accounts = new LinkedHashSet<MojangUser>(users);
        this.startDate = startDate;
        this.endDate = endDate;
        this.updateUserJobs();
        this.updateCallback();
        this.updateLocale();
    }

    private void updateUserJobs() {
        if (this.startDate == null) {
            this.accounts.forEach(u -> u.isReadyToMigrate().get().thenAccept(b -> this.updateCallback()));
        }
    }

    private void updateCallback() {
        SwingUtil.later(() -> {
            this.updateAccountsCount();
            this.accountsList.removeAll();
            if (!this.accounts.isEmpty()) {
                JSeparator s = new JSeparator();
                s.setAlignmentX(0.0f);
                s.setAlignmentY(0.0f);
                this.accountsList.add(Box.createRigidArea(new Dimension(1, HALF_BORDER)));
                this.accountsList.add((Component)s);
            }
            this.accounts.stream().sorted((ac1, ac0) -> {
                if (this.startDate != null) {
                    return 0;
                }
                int s = ac0.getMigrationStatusNow().compareTo(ac1.getMigrationStatusNow());
                if (s == 0) {
                    return ac0.getDisplayName().compareTo(ac1.getDisplayName());
                }
                return s;
            }).forEach(u -> {
                ExtendedPanel bp;
                boolean forcedMigrationStarted;
                BorderPanel p = new BorderPanel();
                p.setBorder(BorderFactory.createEmptyBorder(HALF_BORDER, 0, HALF_BORDER, 0));
                p.setAlignmentX(0.0f);
                p.setAlignmentY(0.0f);
                ExtendedLabel l = new ExtendedLabel(u.getDisplayName());
                l.setIconTextGap(HALF_BORDER);
                ImageIcon.setup(l, Images.getIcon16("logo-mojang"));
                p.setWest(l);
                MojangUserMigrationStatus status = null;
                boolean canMigrateNow = false;
                boolean bl = forcedMigrationStarted = this.startDate != null && Instant.now().isAfter(this.startDate);
                if (forcedMigrationStarted) {
                    canMigrateNow = true;
                } else if (this.startDate != null) {
                    status = new MojangUserMigrationStatus(true);
                } else {
                    CompletableFuture<MojangUserMigrationStatus> f = u.isReadyToMigrate().get();
                    if (f.isDone()) {
                        try {
                            status = f.get();
                        }
                        catch (InterruptedException | ExecutionException exception) {}
                    } else {
                        p.setEast(new LocalizableLabel("mojang-migration.your-accounts.list.waiting"));
                    }
                }
                if (status != null) {
                    if (status.getError() == null) {
                        if (status.canMigrate()) {
                            canMigrateNow = true;
                        } else {
                            LocalizableHTMLLabel nl = new LocalizableHTMLLabel("mojang-migration.your-accounts.list.not-eligible");
                            nl.setToolTipText(Localizable.get("mojang-migration.your-accounts.list.not-eligible.hint"));
                            p.setEast(nl);
                        }
                    } else {
                        bp = new ExtendedPanel();
                        bp.setAlignmentX(1.0f);
                        bp.setLayout(new BoxLayout(bp, 0));
                        bp.add((Component)new LocalizableHTMLLabel("mojang-migration.your-accounts.list.probably-migrated"));
                        bp.add(Box.createRigidArea(new Dimension(QUARTER_BORDER, 0)));
                        LocalizableButton yes = new LocalizableButton("mojang-migration.your-accounts.list.probably-migrated.yes");
                        yes.addActionListener(e -> {
                            if (Alert.showLocQuestion("mojang-migration.your-accounts.list.probably-migrated.yes.remove")) {
                                TLauncher.getInstance().getProfileManager().getAccountManager().getUserSet().remove(u);
                            }
                        });
                        bp.add((Component)yes);
                        bp.add(Box.createRigidArea(new Dimension(QUARTER_BORDER, 0)));
                        LocalizableButton no = new LocalizableButton("mojang-migration.your-accounts.list.probably-migrated.no");
                        no.addActionListener(e -> {
                            if (Alert.showLocQuestion("mojang-migration.your-accounts.list.probably-migrated.no.open-manager")) {
                                TLauncher.getInstance().getFrame().mp.openAccountEditor();
                                TLauncher.getInstance().getFrame().mp.accountManager.get().multipane.showTip("add-account-mojang");
                                this.dispose();
                            }
                        });
                        bp.add((Component)no);
                        p.setEast(bp);
                    }
                }
                if (canMigrateNow) {
                    l.setFont(l.getFont().deriveFont(1));
                    bp = new ExtendedPanel();
                    bp.setAlignmentX(1.0f);
                    bp.setLayout(new BoxLayout(bp, 0));
                    LocalizableButton eb = new LocalizableButton("mojang-migration.your-accounts.list.migrate.show-email");
                    eb.addActionListener(e -> Alert.showMessage("", "Email:", u.getUsername()));
                    bp.add((Component)eb);
                    bp.add(Box.createRigidArea(new Dimension(QUARTER_BORDER, 0)));
                    LocalizableButton mb = new LocalizableButton("mojang-migration.your-accounts.list.migrate");
                    mb.addActionListener(e -> OS.openLink("https://aka.ms/MinecraftMigration"));
                    mb.setFont(mb.getFont().deriveFont(1));
                    bp.add((Component)mb);
                    if (forcedMigrationStarted) {
                        LocalizableButton db = new LocalizableButton("mojang-migration.your-accounts.list.remove.button");
                        db.addActionListener(e -> {
                            if (Alert.showLocQuestion("mojang-migration.your-accounts.list.remove")) {
                                TLauncher.getInstance().getProfileManager().getAccountManager().getUserSet().remove(u);
                            }
                        });
                        bp.add(Box.createRigidArea(new Dimension(QUARTER_BORDER, 0)));
                        bp.add((Component)db);
                    }
                    p.setEast(bp);
                }
                this.accountsList.add((Component)p);
                JSeparator s = new JSeparator();
                s.setAlignmentX(0.0f);
                s.setAlignmentY(0.0f);
                this.accountsList.add((Component)s);
            });
            if (!this.accounts.isEmpty()) {
                this.accountsList.add(Box.createRigidArea(new Dimension(0, HALF_BORDER)));
                LocalizableButton helpButton = new LocalizableButton("mojang-migration.help.button");
                helpButton.addActionListener(e -> OS.openLink(TLauncher.getInstance().getSettings().isLikelyRussianSpeakingLocale() ? "https://llaun.ch/movehelpru" : "https://llaun.ch/movehelp"));
                LocalizableButton nadoButton = new LocalizableButton("mojang-migration.nado.button");
                nadoButton.addActionListener(e -> Alert.showLocMessage("mojang-migration.nado"));
                BorderPanel bp = new BorderPanel();
                bp.setAlignmentX(0.0f);
                bp.setAlignmentY(0.0f);
                bp.setWest(nadoButton);
                bp.setEast(helpButton);
                this.accountsList.add((Component)bp);
            }
            this.accountsList.revalidate();
        });
    }

    private void updateAccountsCount() {
        if (this.accounts == null) {
            this.accountsCount.setText(null);
        } else if (this.accounts.isEmpty()) {
            this.accountsCount.setText("mojang-migration.your-accounts.count.none");
        } else {
            this.accountsCount.setText("mojang-migration.your-accounts.count.some", this.accounts.size());
        }
    }

    @Override
    public void updateLocale() {
        Localizable.updateContainer(this.getContentPane());
        this.setTitle(Localizable.get("mojang-migration.title"));
        String explanationLink = TLauncher.getInstance().getSettings().isLikelyRussianSpeakingLocale() ? "https://llaun.ch/movefaqru" : "https://llaun.ch/movefaq";
        StringBuilder explanation = new StringBuilder();
        explanation.append(Localizable.get("mojang-migration.body.explanation.text"));
        if (this.startDate != null) {
            explanation.append("<br/><br/>").append(Localizable.get("mojang-migration.body.explanation.with-start-date.v1.past", this.dateFormatter.get().format(this.startDate)));
        }
        if (this.endDate != null) {
            explanation.append("<br/><br/>").append(Localizable.get("mojang-migration.body.explanation.with-end-date.v1." + (Instant.now().isBefore(this.endDate) ? "future" : "past"), this.dateFormatter.get().format(this.endDate)));
        }
        explanation.append(" <a href=\"").append(explanationLink).append("\">");
        explanation.append(Localizable.get("mojang-migration.body.explanation.link"));
        explanation.append("</a>");
        this.explanationLabel.setText(explanation.toString());
        this.explanationLabel.setPreferredSize(new Dimension(WIDTH_BORDERED, SwingUtil.getPrefHeight(this.explanationLabel, WIDTH_BORDERED)));
        this.updateAccountsCount();
    }
}

