/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.minecraft.crash.CrashManager;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftException;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftExtendedListener;
import ru.turikhay.tlauncher.ui.TLauncherFrame;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.background.BackgroundManager;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.progress.LaunchProgress;
import ru.turikhay.tlauncher.ui.progress.ProgressBar;
import ru.turikhay.tlauncher.ui.scenes.AccountManagerScene;
import ru.turikhay.tlauncher.ui.scenes.DefaultScene;
import ru.turikhay.tlauncher.ui.scenes.NoticeScene;
import ru.turikhay.tlauncher.ui.scenes.PseudoScene;
import ru.turikhay.tlauncher.ui.scenes.VersionManagerScene;
import ru.turikhay.tlauncher.ui.swing.DelayedComponent;
import ru.turikhay.tlauncher.ui.swing.DelayedComponentLoader;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedLayeredPane;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.util.OS;

public class MainPane
extends ExtendedLayeredPane {
    private static final Logger LOGGER = LogManager.getLogger(MainPane.class);
    private final TLauncherFrame rootFrame;
    private final boolean repaintEveryTime;
    private PseudoScene scene;
    public final BackgroundManager background;
    public final DelayedComponent<LaunchProgress> progress;
    public final DefaultScene defaultScene;
    public final DelayedComponent<AccountManagerScene> accountManager;
    public final DelayedComponent<VersionManagerScene> versionManager;
    public final DelayedComponent<NoticeScene> noticeScene;
    public final DelayedComponent<RevertFontSize> revertFont;

    MainPane(final TLauncherFrame frame) {
        super(null);
        this.rootFrame = frame;
        this.repaintEveryTime = OS.LINUX.isCurrent();
        LOGGER.trace("Creating background...");
        this.background = new BackgroundManager(this);
        this.add((Component)this.background);
        LOGGER.trace("Init Default scene...");
        this.defaultScene = new DefaultScene(this);
        this.add((Component)this.defaultScene);
        LOGGER.trace("Init Account manager scene...");
        this.accountManager = new DelayedComponent<AccountManagerScene>(new DelayedComponentLoader<AccountManagerScene>(){

            @Override
            public AccountManagerScene loadComponent() {
                return new AccountManagerScene(MainPane.this);
            }

            @Override
            public void onComponentLoaded(AccountManagerScene scene) {
                MainPane.this.add((Component)scene);
                scene.onResize();
                scene.list.updateList();
                Account<? extends User> selected = scene.list.getSelected();
                if (selected != null) {
                    MainPane.this.defaultScene.loginForm.accounts.setAccount(selected);
                }
            }
        });
        LOGGER.trace("Init Version manager scene...");
        this.versionManager = new DelayedComponent<VersionManagerScene>(new DelayedComponentLoader<VersionManagerScene>(){

            @Override
            public VersionManagerScene loadComponent() {
                return new VersionManagerScene(MainPane.this);
            }

            @Override
            public void onComponentLoaded(VersionManagerScene loaded) {
                MainPane.this.add((Component)loaded);
                TLauncher.getInstance().getVersionManager().asyncRefresh(true);
                loaded.onResize();
            }
        });
        this.noticeScene = new DelayedComponent<NoticeScene>(new DelayedComponentLoader<NoticeScene>(){

            @Override
            public NoticeScene loadComponent() {
                return new NoticeScene(MainPane.this);
            }

            @Override
            public void onComponentLoaded(NoticeScene loaded) {
                MainPane.this.add((Component)loaded);
                loaded.onResize();
            }
        });
        this.progress = new DelayedComponent<LaunchProgress>(new DelayedComponentLoader<LaunchProgress>(){

            @Override
            public LaunchProgress loadComponent() {
                return new LaunchProgress(frame);
            }

            @Override
            public void onComponentLoaded(LaunchProgress loaded) {
                MainPane.this.add((Component)loaded);
                MainPane.this.onResize();
            }
        });
        frame.getLauncher().getUIListeners().registerMinecraftLauncherListener(new MinecraftExtendedListener(){

            @Override
            public void onMinecraftCollecting() {
                MainPane.this.progress.get().onMinecraftCollecting();
            }

            @Override
            public void onMinecraftComparingAssets(boolean fast) {
                MainPane.this.progress.get().onMinecraftComparingAssets(fast);
            }

            @Override
            public void onMinecraftCheckingJre() {
                MainPane.this.progress.get().onMinecraftCheckingJre();
            }

            @Override
            public void onMinecraftMalwareScanning() {
                MainPane.this.progress.get().onMinecraftMalwareScanning();
            }

            @Override
            public void onMinecraftDownloading() {
                MainPane.this.progress.get().onMinecraftDownloading();
            }

            @Override
            public void onMinecraftReconstructingAssets() {
                MainPane.this.progress.get().onMinecraftReconstructingAssets();
            }

            @Override
            public void onMinecraftUnpackingNatives() {
                MainPane.this.progress.get().onMinecraftUnpackingNatives();
            }

            @Override
            public void onMinecraftDeletingEntries() {
                MainPane.this.progress.get().onMinecraftDeletingEntries();
            }

            @Override
            public void onMinecraftConstructing() {
                MainPane.this.progress.get().onMinecraftConstructing();
            }

            @Override
            public void onMinecraftLaunch() {
                MainPane.this.progress.get().onMinecraftLaunch();
            }

            @Override
            public void onMinecraftPostLaunch() {
                MainPane.this.progress.get().onMinecraftPostLaunch();
            }

            @Override
            public void onMinecraftPrepare() {
                MainPane.this.progress.get().onMinecraftPrepare();
            }

            @Override
            public void onMinecraftAbort() {
                MainPane.this.progress.get().onMinecraftAbort();
            }

            @Override
            public void onMinecraftClose() {
                MainPane.this.progress.get().onMinecraftClose();
            }

            @Override
            public void onMinecraftError(Throwable var1) {
                MainPane.this.progress.get().onMinecraftError(var1);
            }

            @Override
            public void onMinecraftKnownError(MinecraftException var1) {
                MainPane.this.progress.get().onMinecraftKnownError(var1);
            }

            @Override
            public void onCrashManagerInit(CrashManager manager) {
                MainPane.this.progress.get().onCrashManagerInit(manager);
            }
        });
        this.revertFont = new DelayedComponent<RevertFontSize>(new DelayedComponentLoader<RevertFontSize>(){

            @Override
            public RevertFontSize loadComponent() {
                return new RevertFontSize();
            }

            @Override
            public void onComponentLoaded(RevertFontSize loaded) {
                MainPane.this.add((Component)loaded);
                MainPane.this.onResize();
            }
        });
        if (this.shouldShowRevertFont()) {
            this.revertFont.load();
        }
        this.setScene(this.defaultScene, false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MainPane.this.onResize();
            }
        });
    }

    public PseudoScene getScene() {
        return this.scene;
    }

    public void setScene(PseudoScene scene) {
        this.setScene(scene, true);
    }

    public void setScene(PseudoScene newscene, boolean animate) {
        if (newscene == null) {
            throw new NullPointerException();
        }
        if (!newscene.equals(this.scene)) {
            for (Component comp : this.getComponents()) {
                if (comp.equals(newscene) || !(comp instanceof PseudoScene)) continue;
                ((PseudoScene)comp).setShown(false, animate);
            }
            this.scene = newscene;
            this.scene.setShown(true);
            if (this.repaintEveryTime) {
                this.repaint();
            }
        }
    }

    public void openDefaultScene() {
        this.setScene(this.defaultScene);
    }

    public void openAccountEditor() {
        this.setScene(this.accountManager.get());
    }

    public void openVersionManager() {
        this.setScene(this.versionManager.get());
    }

    public void openNoticeScene() {
        this.setScene(this.noticeScene.get());
    }

    public TLauncherFrame getRootFrame() {
        return this.rootFrame;
    }

    public DelayedComponent<LaunchProgress> getProgress() {
        return this.progress;
    }

    @Override
    public void onResize() {
        if (this.progress.isLoaded()) {
            this.progress.get().setBounds(0, this.getHeight() - ProgressBar.DEFAULT_HEIGHT + 1, this.getWidth(), ProgressBar.DEFAULT_HEIGHT);
        }
        if (this.revertFont.isLoaded()) {
            this.revertFont.get().setBounds(0, 0, this.getWidth(), this.getFontMetrics(this.revertFont.get().revertButton.getFont()).getHeight() * 3);
        }
    }

    public Point getLocationOf(Component comp) {
        Point compLocation = comp.getLocationOnScreen();
        Point paneLocation = this.getLocationOnScreen();
        return new Point(compLocation.x - paneLocation.x, compLocation.y - paneLocation.y);
    }

    private boolean shouldShowRevertFont() {
        float size = this.rootFrame.getConfiguration().getInteger("gui.font.old");
        if (size < 12.0f || size > 18.0f) {
            size = 18.0f;
        }
        float oldSize = size;
        return TLauncherFrame.getFontSize() != oldSize;
    }

    public class RevertFontSize
    extends ExtendedPanel
    implements LocalizableComponent {
        private final LocalizableButton revertButton;
        private final LocalizableButton closeButton;
        private final int oldSizeInt;

        private RevertFontSize() {
            float size = MainPane.this.rootFrame.getConfiguration().getInteger("gui.font.old");
            if (size < 12.0f || size > 18.0f) {
                size = 18.0f;
            }
            float oldSize = size;
            this.oldSizeInt = (int)size;
            this.revertButton = new LocalizableButton("revert.font.approve");
            this.revertButton.setFont(this.revertButton.getFont().deriveFont(size));
            this.revertButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainPane.this.defaultScene.settingsForm.get().font.setValue(RevertFontSize.this.oldSizeInt);
                    MainPane.this.defaultScene.settingsForm.get().saveValues();
                    Alert.showLocMessage("revert.font.approved");
                    RevertFontSize.this.closeButton.doClick();
                }
            });
            this.closeButton = new LocalizableButton("revert.font.close");
            this.closeButton.setToolTipText("revert.font.close.hint");
            this.closeButton.setFont(this.closeButton.getFont().deriveFont(1, size));
            this.closeButton.addActionListener(e -> {
                MainPane.this.rootFrame.getConfiguration().set("gui.font.old", MainPane.this.rootFrame.getConfiguration().getInteger("gui.font"));
                MainPane.this.remove(this);
                MainPane.this.repaint();
            });
            this.add((Component)this.revertButton, (Object)this.closeButton);
            this.updateLocale();
        }

        @Override
        public void updateLocale() {
            Localizable.updateContainer(this);
        }
    }
}

