/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.time.Instant;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import ru.turikhay.tlauncher.ui.images.FixedSizeImage;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.swing.editor.EditorPane;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedFrame;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.ui.theme.Theme;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;

public class LLaunchFrame
extends ExtendedFrame
implements LocalizableComponent {
    private static final int SIZE = SwingUtil.magnify(500);
    private static final int IMAGE_HEIGHT = SIZE / 2;
    private static final int BORDER = SwingUtil.magnify(20);
    private static final int HALF_BORDER = BORDER / 2;
    private static final int WIDTH_BORDERED = SIZE - BORDER * 2;
    private final Runnable disposeListener;
    private final EditorPane explanationLabel;
    private static LLaunchFrame INSTANCE;

    public LLaunchFrame(Runnable disposeListener) {
        this.disposeListener = disposeListener;
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setIconImages(SwingUtil.getFavicons());
        this.setResizable(false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 1.0;
        FixedSizeImage image = new FixedSizeImage(Images.loadImageByName("llaunch.jpg"));
        image.setPreferredSize(new Dimension(SIZE, IMAGE_HEIGHT));
        c.fill = 1;
        c.weighty = 1.0;
        ++c.gridy;
        this.add((Component)image, c);
        ExtendedPanel container = new ExtendedPanel();
        c.fill = 1;
        c.weighty = 0.0;
        ++c.gridy;
        this.add((Component)container, c);
        container.setLayout(new BoxLayout(container, 1));
        container.setBorder(BorderFactory.createEmptyBorder(BORDER, BORDER, BORDER, BORDER));
        LocalizableLabel head = new LocalizableLabel("llaunch.head");
        head.setAlignmentX(0.0f);
        head.setAlignmentY(0.0f);
        head.setFont(head.getFont().deriveFont(1, head.getFont().getSize2D() + 3.0f));
        head.setForeground(Theme.getTheme().getSemiForeground());
        container.add((Component)head);
        container.add(Box.createRigidArea(new Dimension(1, HALF_BORDER)));
        this.explanationLabel = new EditorPane();
        this.explanationLabel.setAlignmentX(0.0f);
        this.explanationLabel.setAlignmentY(0.0f);
        container.add((Component)this.explanationLabel);
        container.add(Box.createRigidArea(new Dimension(1, BORDER)));
        ExtendedPanel buttonsPanel = new ExtendedPanel();
        buttonsPanel.setAlignmentX(0.0f);
        buttonsPanel.setAlignmentY(0.0f);
        GridBagLayout bl = new GridBagLayout();
        bl.columnWeights = new double[]{0.0, 1.0, 0.0};
        bl.rowHeights = new int[]{30};
        buttonsPanel.setLayout(bl);
        LocalizableButton learnMore = new LocalizableButton("llaunch.btn.learn-more");
        learnMore.addActionListener(e -> OS.openLink("https://llaun.ch/ex-tl-legacy"));
        buttonsPanel.add((Component)learnMore, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        LocalizableButton ok = new LocalizableButton("llaunch.btn.ok");
        ok.addActionListener(e -> this.dispose());
        buttonsPanel.add((Component)ok, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)buttonsPanel);
        this.getRootPane().setDefaultButton(ok);
        this.updateLocale();
        this.pack();
    }

    public LLaunchFrame() {
        this((Runnable)null);
    }

    @Override
    public void updateLocale() {
        Localizable.updateContainer(this.getContentPane());
        this.setTitle(Localizable.get("llaunch.title"));
        this.explanationLabel.setText(Localizable.get("llaunch.body.0") + "<br/><br/>" + Localizable.get("llaunch.body.1") + "<br/><br/>" + Localizable.get("llaunch.body.2"));
        this.explanationLabel.setPreferredSize(new Dimension(WIDTH_BORDERED, SwingUtil.getPrefHeight(this.explanationLabel, WIDTH_BORDERED)));
        this.revalidate();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.disposeListener != null) {
            this.disposeListener.run();
        }
    }

    public static void showInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LLaunchFrame(() -> {
                INSTANCE = null;
            });
        }
        INSTANCE.showAtCenter();
    }

    public static boolean isNotPostTlaunchEra() {
        return Instant.now().isBefore(Instant.parse("2023-08-01T00:00:00Z"));
    }
}

